from viset.ethzshapes import ETHZExtendedShapeClasses
from viset.dataset import Viset
from viset.show import imshow, imbbox

def main():
  # Create a new viset
  print '[test_ethzshapes]: Creating vision dataset for ethzshapes'
  dbfile = ETHZExtendedShapeClasses().export()
  print 'Exporting dataset to redistributable HDF5 file "' + dbfile + '"'

  # Import an existing viset 
  print 'Displaying database properties'
  db = Viset(dbfile)
  print db
    
  print '[test_ethzshapes]: Displaying all images in "' + dbfile + '"'
  for (im,annotation) in db['dataset']:
    print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
    if im is not None:
      imbbox(im,annotation['bbox_xmin'],annotation['bbox_xmax'],annotation['bbox_ymin'],annotation['bbox_ymax'], bboxcaption=annotation['category'])

if __name__ == '__main__':
  main()
        
