from viset.caltech import Caltech101
from viset.dataset import Viset
from viset.show import imshow
from time import sleep


def main():
  # Create a new viset
  print 'Creating vision dataset for Caltech101 dataset'
  dbfile = Caltech101().export()
  print 'Exporting Caltech101 dataset to redistributable HDF5 file "' + dbfile + '"'
  
  # Import an existing viset 
  print 'Displaying training/testing split in viset (VISion dataSET) "' + dbfile + '"'
  db = Viset(dbfile, split='2fold')
  for (im,annotation) in db['train']:
    print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
    imshow(im, title=annotation['category'])
  for (im,annotation) in db['test']:
    print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
    imshow(im, title=annotation['category'])

  # Cleanup cached data (optional)
  # db.delete()
  
if __name__ == '__main__':
  main()
    
