from viset.caltech import Caltech101
from viset.dataset import Viset
from viset.show import imshow
from time import sleep

def main():
  dbfile = 'caltech101.h5'
  
  print '[test_viset.py]: open database'
  db = Viset(dbfile)
  print db

  print '[test_viset.py]: open dataset task'
  db = Viset(dbfile, task='Categorization')
  
  print '[test_viset.py]: import from path'  
  db = Viset('/Users/jebyrne/.visym/caltech101.h5')
  
  print '[test_viset.py]: opening invalid dataset'  
  try:
    db = Viset('invalid.path.to.hdf5')  
  except:
    print 'Correctly raised exception'

  print '[test_viset.py]: opening invalid dataset'      
  try:
    db = Viset(1)  
  except:
    print 'Correctly raised exception'

  print '[test_viset.py]: opening invalid dataset'          
  try:
    db = Viset('http://www.visym.com')
  except:
    print 'Correctly raised exception'        

  print '[test_viset.py]: open dataset task'
  try:
    db = Viset('caltech101.h5', task='this.is.an.invalid.task')
  except:
    print 'Correctly raised exception'        

  print '[test_viset.py]: dataset labeling'
  db = Viset(dbfile)
  print db.y(db.labels()[0])

  print '[test_viset.py]: dataset splits'  
  db = Viset(dbfile,split='kfold',kfold=3)
  for k in range(0,2):
    for (im,anno) in db[k]['test']:
      print anno

  print '[test_viset.py]: dataset splits'  
  db = Viset(dbfile,split='2fold')
  for (im,anno) in db['train']:
    print anno
  for (im,anno) in db['test']:
    print anno

  print '[test_viset.py]: dataset splits'
  db = Viset(dbfile,split=None)
  for (im,anno) in db['dataset']:
    print anno

  
    

    
  
if __name__ == '__main__':
  main()

  
