from viset.labelme import LabelMe3
from viset.dataset import Viset
from viset.show import imshow
from viset.util import iscached, incache

def main():
    if not iscached('labelme3.h5'):
        dbfile = LabelMe3().export()
    else:
        dbfile = incache('labelme3.h5')
    
    db = Viset(dbfile, datastep=100, verbose=True, async=False)
    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        if im is not None:
            imshow(im)

if __name__ == '__main__':
  main()

