import tables
import os
from os import path
import viset.download
from viset.dataset import Viset


class PascalVOC(Viset):
    def export(self, redo=False):
        # Create empty database
        self.create(view=['Categorization', 'Detection', 'Segmentation'])

        # CONVENIENCE: don't accidentally clear 2GB on a dumb typo
        self.dbcache._refetch = False
        
        # Fetch data necessary to initial construction
        pkgdir = self.dbcache.get(self.URL, sha1=self.SHA1)

        # Write images to database
        imsetdir = path.join(pkgdir, self.IMSETDIR)                              
        id_img = 0  
        for line in open(path.join(imsetdir,'trainval.txt'),'r'):        
            im = line.strip() + '.jpg'
            self.add_image(id_img, path.join(self.IMDIR,im), 1, id_img, url=self.URL)
            id_img += 1
        self.write()

        # Categorization annotations
        imsetdir = path.join(pkgdir, self.IMSETDIR)                      
        id_category = 0
        for imset in os.listdir(imsetdir):
            (filebase,ext) = path.splitext(path.basename(imset))
            try:
                (category,set) = filebase.split('_')            
            except:
                continue
            if set == 'trainval':
                id_img = 0
                for line in open(path.join(imsetdir,imset),'r'):
                    (im,label) = line.strip().split()
                    if int(label) == 1:
                        self.dbview.add_categorization(id_category, category, id_img)  
                    id_img += 1
            id_category += 1
        self.write()

        # Detection annotations
        #self.view('Detection')
        #tree = ET.parse(xmlfile)
        #root = tree.getroot()
        
                
        # Cleanup
        self.close()
        return self.dbfile

class PascalVOC2012(PascalVOC):
  URL = 'http://pascallin.ecs.soton.ac.uk/challenges/VOC/voc2012/VOCtrainval_11-May-2012.tar'
  SHA1 = None
  IMDIR = 'VOCdevkit/VOC2012/JPEGImages'
  IMSETDIR = 'VOCdevkit/VOC2012/ImageSets/Main'
  _dbname = 'pascalvoc_2012'
  
