from viset.library.weizmannhorses import WeizmannHorsesSingleScale
from viset.dataset import Viset
from viset.show import imshow

def main():
    dbfile = WeizmannHorsesSingleScale().export()
    db = Viset(dbfile, verbose=True)
    for (im,annotation) in db.annotation.segmentation:
        imshow(im, title='horses')
        imshow(annotation['mask'], title='mask')
    
if __name__ == '__main__':
    main()

  
