from viset.library.weizmannhorses import WeizmannHorsesMultiScale
from viset.dataset import Viset
from viset.show import imshow

def main():
    dbfile = WeizmannHorsesMultiScale(verbose=True).export()
    db = Viset(dbfile, verbose=True)
    for (im,annotation) in db.annotation.segmentation:
        imshow(im, title=annotation['category'])
        if annotation['mask'] is not None:
            imshow(annotation['mask'], title='mask')
    
if __name__ == '__main__':
    main()

  
