from viset.library.caltech101 import Caltech101
from viset.dataset import Viset
from viset.show import imshow
from time import sleep


def main():
    # Create a new viset
    print 'Creating vision dataset for Caltech101 dataset'
    dbfile = Caltech101().export()
    db = Viset(dbfile, verbose=True)
    print 'Displaying dataset details'
    print db
    
    # Show dataset
    print 'Displaying single image from viset (VISion dataSET) "' + dbfile + '"'
    imshow(db.image[0])

    # Show all images with a step
    print 'Show every 1000th image from viset (VISion dataSET) "' + dbfile + '"'
    for im in db.image(step=1000):
        imshow(im)

    # Show all annotations
    print 'Show every 1000th image and annotation from viset (VISion dataSET) "' + dbfile + '"'
    for (im, annotation) in db.annotation.categorization(step=1000):
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im)

    # Show a random training/testing split
    print 'Show every 500th image and annotation from a random training and testing split in "' + dbfile + '"'
    split = db.annotation.categorization(step=500, strategy='train-test', randomize=True)
    for (im, annotation) in split.train:
        print 'Training image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im)
    for (im, annotation) in split.test:
        print 'Testing image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im)

    # kfold splits
    foldindex = 1
    print 'Show every 1000th image and annotation from a kfold split in "' + dbfile + '"'      
    for fold in db.annotation.categorization(step=1000, strategy='kfold', folds=3):
        print 'Fold # ' + str(foldindex)
        for (im, annotation) in fold.train:
            print 'Training image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
            imshow(im)
        for (im, annotation) in fold.test:
            print 'Testing image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
            imshow(im)
        foldindex += 1
      
    # Cleanup cached data (optional)
    # del(db)
  
if __name__ == '__main__':
    main()
    
