from viset.cache import Cache
from viset.show import imshow
from time import sleep

def main():
    c = Cache(verbose=True)
    
    print '[test_cache]: download an image and retrieve from cache'    
    imshow(c.get('http://upload.wikimedia.org/wikipedia/commons/3/39/Athene_noctua_(cropped).jpg'))
    imshow(c.get('http://upload.wikimedia.org/wikipedia/commons/3/39/Athene_noctua_(cropped).jpg'))

    print '[test_cache]: download archive with item fragment'
    imshow(c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz#item=CarData/TrainImages/pos-1.pgm'))
    imshow(c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz#item=CarData/TrainImages/pos-2.pgm'))
    imshow(c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz#item=CarData/TrainImages/pos-3.pgm'))

    print '[test_cache]: new querystring will trigger a cache miss'
    imshow(c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz?a=1&b=2#item=CarData/TrainImages/pos-4.pgm'))
    imshow(c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz?a=1&b=2#item=CarData/TrainImages/pos-5.pgm'))

    try:
        c.get('http://l2r.cs.uiuc.edu/~cogcomp/Data/Car/CarData.tar.gz#item=wrong_item')
    except:
        print 'incorrect URL fragment raises exception correctly'

    print '[test_cache]: delete cache'
    print c.size()
    c.delete()
    print c.size()    
  
if __name__ == '__main__':
    main()

  
