/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MainPanel
extends JPanel {
    private static final String DOMAIN_PATH = "/var/lib/virtdc/vmonere/monitor_logs/domain/";
    private static final String HOST_PATH = "/var/lib/virtdc/vmonere/monitor_logs/host/";
    private static final long serialVersionUID = 1L;
    private static String vmid;
    private static MemoryMonitoringGraph memoryChart;
    private static CPUMonitoringGraph cpuChart;
    private static IOMonitoringGraph ioChart;
    private static MemoryMonitoringGraph hostOneMemoryChart;
    private static CPUMonitoringGraph hostOneCpuChart;
    private static IOMonitoringGraph hostOneIoChart;
    private static MemoryMonitoringGraph hostTwoMemoryChart;
    private static CPUMonitoringGraph hostTwoCpuChart;
    private static IOMonitoringGraph hostTwoIoChart;
    private static MemoryMonitoringGraph hostThreeMemoryChart;
    private static CPUMonitoringGraph hostThreeCpuChart;
    private static IOMonitoringGraph hostThreeIoChart;
    private static MemoryMonitoringGraph hostFourMemoryChart;
    private static CPUMonitoringGraph hostFourCpuChart;
    private static IOMonitoringGraph hostFourIoChart;
    public JTextField vmIdTextField;
    public JButton submit;
    public JPanel vmPanel;
    public JPanel leftPanel;
    public JPanel rightPanel;

    public MainPanel() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(1024, 700));
        this.leftPanel = new JPanel();
        this.leftPanel.setPreferredSize(new Dimension(700, 700));
        JPanel labelPanel = new JPanel();
        this.vmIdTextField = new JTextField(20);
        this.vmIdTextField.setSize(100, 20);
        this.vmIdTextField.setHorizontalAlignment(0);
        this.submit = new JButton("Submit");
        this.submit.setSize(100, 20);
        this.submit.setHorizontalAlignment(0);
        JLabel text = new JLabel("Domain ID : ");
        text.setHorizontalAlignment(0);
        text.setForeground(Color.black);
        text.setFont(new Font("Calibri", 1, 20));
        labelPanel.setSize(new Dimension(600, 30));
        labelPanel.add(text);
        labelPanel.add(this.vmIdTextField);
        labelPanel.add(this.submit);
        this.vmPanel = new JPanel();
        JPanel northPanel = new JPanel();
        try {
            MainPanel.getMemGraph(null, 100000);
            MainPanel.getCPUGraph(null);
            MainPanel.getIOGraph(null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (memoryChart != null) {
            northPanel.add((Component)memoryChart, "North");
        }
        if (cpuChart != null) {
            northPanel.add((Component)cpuChart, "Center");
        }
        northPanel.setVisible(true);
        if (ioChart != null) {
            northPanel.add((Component)ioChart, "South");
        }
        this.vmPanel.add((Component)northPanel, "South");
        this.vmPanel.setVisible(false);
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("".equals(MainPanel.this.vmIdTextField.getText())) {
                    ValidationMessage.alertMessage("Please enter the domain Id");
                    MainPanel.this.vmIdTextField.requestFocusInWindow();
                } else {
                    try {
                        vmid = MainPanel.this.vmIdTextField.getText();
                        ((Container)((Container)MainPanel.this.getComponent(1)).getComponent(1)).removeAll();
                        ((Container)((Container)MainPanel.this.getComponent(1)).getComponent(1)).repaint();
                        JPanel northPanel = new JPanel(new BorderLayout());
                        northPanel.setSize(new Dimension(600, 500));
                        MainPanel.getMemGraph(vmid, 100000);
                        MainPanel.getCPUGraph(vmid);
                        MainPanel.getIOGraph(vmid);
                        northPanel.add((Component)memoryChart, "North");
                        northPanel.add((Component)cpuChart, "Center");
                        northPanel.add((Component)ioChart, "South");
                        northPanel.setVisible(true);
                        ((Container)((Container)MainPanel.this.getComponent(1)).getComponent(1)).add((Component)northPanel, "South");
                        ((Container)((Container)MainPanel.this.getComponent(1)).getComponent(1)).setVisible(true);
                        ((Container)((Container)MainPanel.this.getComponent(1)).getComponent(1)).validate();
                    }
                    catch (FileNotFoundException fe) {
                        System.out.println(fe.getMessage());
                        MainPanel.this.vmPanel.setVisible(false);
                        ValidationMessage.alertMessage("Log for VM-" + vmid + " does not exist!");
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                        ValidationMessage.alertMessage(ex.getMessage());
                    }
                }
            }
        });
        this.leftPanel.add((Component)labelPanel, "North");
        this.leftPanel.add((Component)this.vmPanel, "South");
        this.rightPanel = new JPanel();
        this.rightPanel.setPreferredSize(new Dimension(650, 700));
        JPanel hostLabelPanel = new JPanel();
        JLabel hostHeader = new JLabel("Host Monitor");
        hostHeader.setHorizontalAlignment(0);
        hostHeader.setForeground(Color.black);
        hostHeader.setFont(new Font("Calibri", 1, 18));
        hostHeader.setSize(520, 20);
        hostLabelPanel.setSize(520, 20);
        hostLabelPanel.add((Component)hostHeader, "North");
        JPanel hostMonitorPanel = new JPanel();
        hostMonitorPanel.setLayout(new GridLayout(4, 1));
        JPanel hostOnePanel = new JPanel();
        hostOnePanel.setSize(500, 200);
        try {
            MainPanel.getHostMemGraph("node1", 1, 0x2000008);
            MainPanel.getHostCPUGraph("node1", 1);
            MainPanel.getHostIOGraph("node1", 1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (hostOneMemoryChart != null) {
            hostOnePanel.add((Component)hostOneMemoryChart, "East");
        }
        if (hostOneCpuChart != null) {
            hostOnePanel.add((Component)hostOneCpuChart, "West");
        }
        if (hostOneIoChart != null) {
            hostOnePanel.add((Component)hostOneIoChart, "Center");
        }
        hostOnePanel.setVisible(true);
        JPanel hostTwoPanel = new JPanel();
        hostTwoPanel.setSize(500, 200);
        try {
            MainPanel.getHostMemGraph("node2", 2, 0x2000008);
            MainPanel.getHostCPUGraph("node2", 2);
            MainPanel.getHostIOGraph("node2", 2);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (hostTwoMemoryChart != null) {
            hostTwoPanel.add((Component)hostTwoMemoryChart, "East");
        }
        if (hostTwoCpuChart != null) {
            hostTwoPanel.add((Component)hostTwoCpuChart, "Center");
        }
        if (hostTwoIoChart != null) {
            hostTwoPanel.add((Component)hostTwoIoChart, "West");
        }
        hostTwoPanel.setVisible(true);
        JPanel hostThreePanel = new JPanel();
        hostThreePanel.setSize(500, 200);
        try {
            MainPanel.getHostMemGraph("node3", 3, 0x2000008);
            MainPanel.getHostCPUGraph("node3", 3);
            MainPanel.getHostIOGraph("node3", 3);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (hostThreeMemoryChart != null) {
            hostThreePanel.add((Component)hostThreeMemoryChart, "East");
        }
        if (hostThreeCpuChart != null) {
            hostThreePanel.add((Component)hostThreeCpuChart, "Center");
        }
        if (hostThreeIoChart != null) {
            hostThreePanel.add((Component)hostThreeIoChart, "West");
        }
        hostThreePanel.setVisible(true);
        JPanel hostFourPanel = new JPanel();
        hostFourPanel.setSize(500, 200);
        try {
            MainPanel.getHostMemGraph("node4", 4, 0x2000008);
            MainPanel.getHostCPUGraph("node4", 4);
            MainPanel.getHostIOGraph("node4", 4);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (hostFourMemoryChart != null) {
            hostFourPanel.add((Component)hostFourMemoryChart, "East");
        }
        if (hostFourCpuChart != null) {
            hostFourPanel.add((Component)hostFourCpuChart, "Center");
        }
        if (hostFourIoChart != null) {
            hostFourPanel.add((Component)hostFourIoChart, "West");
        }
        hostFourPanel.setVisible(true);
        hostMonitorPanel.add(hostOnePanel);
        hostMonitorPanel.add(hostTwoPanel);
        hostMonitorPanel.add(hostThreePanel);
        hostMonitorPanel.add(hostFourPanel);
        hostMonitorPanel.setVisible(true);
        this.rightPanel.add(hostLabelPanel);
        this.rightPanel.add(hostMonitorPanel);
        this.add((Component)this.rightPanel, "East");
        this.add((Component)this.leftPanel, "West");
    }

    public static void getMemGraph(String args, int maxRange) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        vmid = args;
        FileInputStream in = new FileInputStream(DOMAIN_PATH + vmid + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        memoryChart = new MemoryMonitoringGraph("VM Monitoring", String.valueOf(vmid) + "-" + "Memory", vmid, br, 400, 200, maxRange);
        memoryChart.setVisible(true);
        memoryChart.start();
    }

    public static void getCPUGraph(String args) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        vmid = args;
        FileInputStream in = new FileInputStream(DOMAIN_PATH + vmid + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        cpuChart = new CPUMonitoringGraph("VM Monitoring", String.valueOf(vmid) + "-" + "CPU", vmid, br, 400, 200);
        cpuChart.setVisible(true);
        cpuChart.start();
    }

    public static void getIOGraph(String args) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        vmid = args;
        FileInputStream in = new FileInputStream(DOMAIN_PATH + vmid + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        ioChart = new IOMonitoringGraph("VM Monitoring", String.valueOf(vmid) + "-" + "IO", vmid, br, 400, 200);
        ioChart.setVisible(true);
        ioChart.start();
    }

    public static void getHostMemGraph(String args, Integer hostNumber, int maxRange) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        String hostId = args;
        FileInputStream in = new FileInputStream(HOST_PATH + hostId + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        switch (hostNumber) {
            case 1: {
                hostOneMemoryChart = new MemoryMonitoringGraph("", String.valueOf(hostId) + "-" + "Memory", hostId, br, 200, 150, maxRange);
                hostOneMemoryChart.setVisible(true);
                hostOneMemoryChart.start();
                break;
            }
            case 2: {
                hostTwoMemoryChart = new MemoryMonitoringGraph("", String.valueOf(hostId) + "-" + "Memory", hostId, br, 200, 150, maxRange);
                hostTwoMemoryChart.setVisible(true);
                hostTwoMemoryChart.start();
                break;
            }
            case 3: {
                hostThreeMemoryChart = new MemoryMonitoringGraph("", String.valueOf(hostId) + "-" + "Memory", hostId, br, 200, 150, maxRange);
                hostThreeMemoryChart.setVisible(true);
                hostThreeMemoryChart.start();
                break;
            }
            case 4: {
                hostFourMemoryChart = new MemoryMonitoringGraph("", String.valueOf(hostId) + "-" + "Memory", hostId, br, 200, 150, maxRange);
                hostFourMemoryChart.setVisible(true);
                hostFourMemoryChart.start();
            }
        }
    }

    public static void getHostCPUGraph(String args, Integer hostNumber) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        String hostId = args;
        FileInputStream in = new FileInputStream(HOST_PATH + hostId + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        switch (hostNumber) {
            case 1: {
                hostOneCpuChart = new CPUMonitoringGraph("", String.valueOf(hostId) + "-" + "CPU", hostId, br, 200, 150);
                hostOneCpuChart.setVisible(true);
                hostOneCpuChart.start();
                break;
            }
            case 2: {
                hostTwoCpuChart = new CPUMonitoringGraph("", String.valueOf(hostId) + "-" + "CPU", hostId, br, 200, 150);
                hostTwoCpuChart.setVisible(true);
                hostTwoCpuChart.start();
                break;
            }
            case 3: {
                hostThreeCpuChart = new CPUMonitoringGraph("", String.valueOf(hostId) + "-" + "CPU", hostId, br, 200, 150);
                hostThreeCpuChart.setVisible(true);
                hostThreeCpuChart.start();
                break;
            }
            case 4: {
                hostFourCpuChart = new CPUMonitoringGraph("", String.valueOf(hostId) + "-" + "CPU", hostId, br, 200, 150);
                hostFourCpuChart.setVisible(true);
                hostFourCpuChart.start();
            }
        }
    }

    public static void getHostIOGraph(String args, Integer hostNumber) throws IOException, ParseException {
        String currentLine;
        if (args == null) {
            return;
        }
        String hostId = args;
        FileInputStream in = new FileInputStream(HOST_PATH + hostId + ".log");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Date currentDate = new Date();
        Date d1 = null;
        Date d2 = null;
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.trim().equals("")) continue;
            String[] currentValues = currentLine.split("\\|");
            String strCurrLineDate = currentValues[0].trim();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String strCurrentDate = format.format(currentDate);
            d1 = format.parse(strCurrentDate);
            d2 = format.parse(strCurrLineDate);
            long diff = Math.abs(d2.getTime() - d1.getTime());
            long diffSeconds = diff / 1000L;
            if (diffSeconds < 10L) break;
        }
        switch (hostNumber) {
            case 1: {
                hostOneIoChart = new IOMonitoringGraph("", String.valueOf(hostId) + "-" + "IO", hostId, br, 200, 150);
                hostOneIoChart.setVisible(true);
                hostOneIoChart.start();
                break;
            }
            case 2: {
                hostTwoIoChart = new IOMonitoringGraph("", String.valueOf(hostId) + "-" + "IO", hostId, br, 200, 150);
                hostTwoIoChart.setVisible(true);
                hostTwoIoChart.start();
                break;
            }
            case 3: {
                hostThreeIoChart = new IOMonitoringGraph("", String.valueOf(hostId) + "-" + "IO", hostId, br, 200, 150);
                hostThreeIoChart.setVisible(true);
                hostThreeIoChart.start();
                break;
            }
            case 4: {
                hostFourIoChart = new IOMonitoringGraph("", String.valueOf(hostId) + "-" + "IO", hostId, br, 200, 150);
                hostFourIoChart.setVisible(true);
                hostFourIoChart.start();
            }
        }
    }

    private static void startMonitoring() {
        JFrame frame = new JFrame("Monitor");
        frame.add((Component)new MainPanel(), "Center");
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setSize(screenSize);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainPanel.startMonitoring();
            }
        });
    }
}

