/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer;

import com.orsoncharts.Range;
import com.orsoncharts.renderer.AbstractColorScale;
import com.orsoncharts.renderer.ColorScale;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;

public class RainbowScale
extends AbstractColorScale
implements ColorScale {
    public static final Range ALL_HUES = new Range(0.0, 1.0);
    public static final Range BLUE_TO_RED_RANGE = new Range(0.0, 0.6666);
    private Color[] colors;
    private Range hueSubrange;

    public RainbowScale(Range range) {
        this(range, 256, BLUE_TO_RED_RANGE);
    }

    public RainbowScale(Range range, int samples, Range hueSubrange) {
        super(range);
        ArgChecks.nullNotPermitted(hueSubrange, "hueSubrange");
        this.colors = new Color[samples];
        this.hueSubrange = hueSubrange;
    }

    public int getSampleCount() {
        return this.colors.length;
    }

    public Range getHueSubrange() {
        return this.hueSubrange;
    }

    @Override
    public Color valueToColor(double value) {
        Range r = this.getRange();
        if (value < r.getMin()) {
            return this.valueToColor(r.getMin());
        }
        if (value > r.getMax()) {
            return this.valueToColor(r.getMax());
        }
        double fraction = this.getRange().percent(value);
        int i = (int)(fraction * (double)(this.colors.length - 1));
        if (this.colors[i] == null) {
            this.colors[i] = this.createRainbowColor(fraction);
        }
        return this.colors[i];
    }

    private Color createRainbowColor(double fraction) {
        double inv = 1.0 - fraction;
        double hue = this.hueSubrange.value(inv);
        return Color.getHSBColor((float)hue, 1.0f, 1.0f);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RainbowScale)) {
            return false;
        }
        RainbowScale that = (RainbowScale)obj;
        if (this.colors.length != that.colors.length) {
            return false;
        }
        if (!this.hueSubrange.equals(that.hueSubrange)) {
            return false;
        }
        return super.equals(obj);
    }
}

