/*
 * Decompiled with CFR 0.152.
 */
package com.monitoring.cpu;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.DynamicTimeSeriesCollection;
import org.jfree.data.time.Second;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CPUMonitoringGraph
extends ApplicationFrame {
    private static final String TITLE = "CPU Monitoring Graph";
    private static final int COUNT = 180;
    private static final int FAST = 100;
    private Timer timer;
    public static BufferedReader br;
    public static String vmid;

    public CPUMonitoringGraph(String title) {
        super(title);
        final DynamicTimeSeriesCollection dataset = new DynamicTimeSeriesCollection(1, 180, new Second());
        dataset.setTimeBase(new Second());
        dataset.addSeries(this.cpuData(), 0, (Comparable)((Object)"CPU data"));
        JFreeChart chart = this.createChart(dataset);
        this.add((Component)new ChartPanel(chart), "Center");
        this.timer = new Timer(100, new ActionListener(){
            float[] newData = new float[1];

            @Override
            public void actionPerformed(ActionEvent e) {
                this.newData[0] = CPUMonitoringGraph.this.fetchCPUData();
                dataset.advanceTime();
                dataset.appendData(this.newData);
            }
        });
    }

    private float fetchCPUData() {
        try {
            String currentLine = br.readLine();
            if (currentLine != null && !currentLine.trim().equals("")) {
                String[] currentValues = currentLine.split("\\|");
                float cpuValue = Float.valueOf(currentValues[1].trim()).floatValue();
                return cpuValue;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0f;
    }

    private float[] cpuData() {
        float[] a = new float[180];
        int i = 0;
        while (i < a.length) {
            a[i] = this.fetchCPUData();
            ++i;
        }
        return a;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart result = ChartFactory.createTimeSeriesChart(TITLE, "", "Value", dataset, true, true, false);
        XYPlot plot = result.getXYPlot();
        ValueAxis domain = plot.getDomainAxis();
        domain.setAutoRange(true);
        ValueAxis range = plot.getRangeAxis();
        range.setRange(0.0, 800.0);
        return result;
    }

    public void start() {
        this.timer.start();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Please provide valid inputs!");
            return;
        }
        vmid = args[0];
        try {
            FileInputStream in = new FileInputStream("/var/lib/virtdc/logs/monitor_logs/" + vmid + ".log");
            br = new BufferedReader(new InputStreamReader(in));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CPUMonitoringGraph demo = new CPUMonitoringGraph("CPU Monitoring Graph-" + vmid);
                    demo.pack();
                    RefineryUtilities.centerFrameOnScreen(demo);
                    demo.setVisible(true);
                    demo.start();
                }
            });
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found!!");
            e.printStackTrace();
        }
    }
}

