/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.DefaultFontMapper;
import com.orsonpdf.Dictionary;
import com.orsonpdf.FontKey;
import com.orsonpdf.FontMapper;
import com.orsonpdf.PDFDocument;
import com.orsonpdf.PDFFont;
import com.orsonpdf.PDFObject;
import com.orsonpdf.Page;
import com.orsonpdf.util.Args;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Pages
extends PDFObject {
    private PDFDocument parent;
    private List<Page> pages;
    private List<PDFFont> fonts;
    private Map<FontKey, PDFFont> fontMap;
    private int nextFont = 1;
    private FontMapper fontMapper;

    Pages(int number, int generation, PDFDocument parent) {
        super(number, generation);
        Args.nullNotPermitted(parent, "parent");
        this.parent = parent;
        this.pages = new ArrayList<Page>();
        this.fonts = new ArrayList<PDFFont>();
        this.fontMap = new HashMap<FontKey, PDFFont>();
        this.fontMapper = new DefaultFontMapper();
    }

    public PDFDocument getDocument() {
        return this.parent;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public List<PDFFont> getFonts() {
        return this.fonts;
    }

    public PDFFont getFont(String name) {
        for (PDFFont f : this.fonts) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    void add(Page page) {
        this.pages.add(page);
    }

    public String findOrCreateFontReference(Font f) {
        FontKey fontKey = FontKey.createFontKey(f);
        PDFFont pdfFont = this.fontMap.get(fontKey);
        if (pdfFont == null) {
            int number = this.parent.getNextNumber();
            String name = "/F" + this.nextFont + "-" + f.getFamily().replace(' ', '_');
            String baseFont = this.fontMapper.mapToBaseFont(f);
            ++this.nextFont;
            pdfFont = new PDFFont(number, 0, name, "/" + baseFont, "/MacRomanEncoding");
            this.fonts.add(pdfFont);
            this.fontMap.put(fontKey, pdfFont);
        }
        return pdfFont.getName();
    }

    private Dictionary createDictionary() {
        Dictionary dictionary = new Dictionary("/Pages");
        Page[] pagesArray = new Page[this.pages.size()];
        for (int i = 0; i < this.pages.size(); ++i) {
            pagesArray[i] = this.pages.get(i);
        }
        dictionary.put("/Kids", pagesArray);
        dictionary.put("/Count", this.pages.size());
        return dictionary;
    }

    @Override
    public byte[] getObjectBytes() {
        return this.createDictionary().toPDFBytes();
    }
}

