/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.data.time.DynamicTimeSeriesCollection;
import org.jfree.data.time.Second;
import org.jfree.data.xy.XYDataset;

public class MemoryMonitoringGraph
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int COUNT = 20;
    private static final int FAST = 500;
    public BufferedReader br;
    public static String vmid;
    private Timer timer;

    public MemoryMonitoringGraph(String applicationTitle, String chartTitle, String args, BufferedReader bReader, int chartWidth, int chartHeight, final int maxRange) {
        super(new BorderLayout());
        this.br = bReader;
        vmid = args;
        final DynamicTimeSeriesCollection dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset, chartTitle, maxRange);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(chartWidth, chartHeight));
        chartPanel.repaint();
        this.add((Component)chartPanel, "Center");
        this.timer = new Timer(500, new ActionListener(){
            float[] newData = new float[1];

            @Override
            public void actionPerformed(ActionEvent e) {
                this.newData[0] = MemoryMonitoringGraph.this.fetchMemData(maxRange);
                dataset.advanceTime();
                dataset.appendData(this.newData);
            }
        });
        this.timer.setInitialDelay(5000);
        this.timer.setDelay(5000);
    }

    private DynamicTimeSeriesCollection createDataset() {
        DynamicTimeSeriesCollection dataset = new DynamicTimeSeriesCollection(1, 20, new Second());
        dataset.setTimeBase(new Second());
        dataset.addSeries(this.memData(), 0, (Comparable)((Object)"Memory data"));
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset, String title, int maxRange) {
        JFreeChart result = ChartFactory.createTimeSeriesChart(title, "", "Value", dataset, true, true, false);
        XYPlot plot = result.getXYPlot();
        plot.setRenderer(new XYAreaRenderer());
        plot.getRenderer().setSeriesPaint(0, Color.BLUE);
        plot.setDomainGridlinesVisible(false);
        ValueAxis domain = plot.getDomainAxis();
        domain.setAutoRange(true);
        domain.setVisible(false);
        ValueAxis range = plot.getRangeAxis();
        range.setRange(0.0, maxRange);
        return result;
    }

    private float fetchMemData(int maxRange) {
        try {
            String currentLine = this.br.readLine();
            if (currentLine != null && !currentLine.trim().equals("")) {
                String[] currentValues = currentLine.split("\\|");
                float memValue = Float.valueOf(currentValues[3].trim()).floatValue();
                if (memValue < 0.0f) {
                    memValue = 0.0f;
                } else if (memValue > (float)maxRange) {
                    memValue = maxRange;
                }
                return memValue;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0f;
    }

    private float[] memData() {
        float[] a = new float[20];
        int i = 0;
        while (i < a.length) {
            a[i] = 0.0f;
            ++i;
        }
        return a;
    }

    public void start() {
        this.timer.start();
    }
}

