/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.TextAnchor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedString;

public class TextUtils {
    private TextUtils() {
    }

    public static Rectangle2D drawAlignedString(String text, Graphics2D g2, float x, float y, TextAnchor anchor) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, anchor, (Rectangle2D)textBounds);
        ((Rectangle2D)textBounds).setRect(x + adjust[0], y + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        g2.drawString(text, x + adjust[0], y + adjust[1]);
        return textBounds;
    }

    public static Rectangle2D calcAlignedStringBounds(String text, Graphics2D g2, float x, float y, TextAnchor anchor) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, anchor, (Rectangle2D)textBounds);
        ((Rectangle2D)textBounds).setRect(x + adjust[0], y + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        return textBounds;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        Rectangle2D bounds = TextUtils.getTextBounds(text, fm);
        LineMetrics metrics = f.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHalfHeight()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor, Rectangle2D textBounds) {
        float[] result = new float[3];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        Rectangle2D bounds = TextUtils.getTextBounds(text, fm);
        LineMetrics metrics = f.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHorizontalCenter()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static Rectangle2D getTextBounds(String text, FontMetrics fm) {
        return TextUtils.getTextBounds(text, 0.0, 0.0, fm);
    }

    public static Rectangle2D getTextBounds(String text, double x, double y, FontMetrics fm) {
        ArgChecks.nullNotPermitted(text, "text");
        ArgChecks.nullNotPermitted(fm, "fm");
        double width = fm.stringWidth(text);
        double height = fm.getHeight();
        return new Rectangle2D.Double(x, y - (double)fm.getAscent(), width, height);
    }

    public static Shape drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, float rotationX, float rotationY) {
        ArgChecks.nullNotPermitted(text, "text");
        float[] textAdj = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        return TextUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, rotationX, rotationY);
    }

    public static Shape drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor) {
        ArgChecks.nullNotPermitted(text, "text");
        float[] textAdj = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        float[] rotateAdj = TextUtils.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        return TextUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics metrics = g2.getFont().getLineMetrics(text, frc);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = TextUtils.getTextBounds(text, fm);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isLeft()) {
            xAdj = 0.0f;
        } else if (anchor.isHorizontalCenter()) {
            xAdj = (float)bounds.getWidth() / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)bounds.getWidth();
        }
        if (anchor.isTop()) {
            yAdj = descent + leading - (float)bounds.getHeight();
        } else if (anchor.isHalfHeight()) {
            yAdj = descent + leading - (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isHalfAscent()) {
            yAdj = -halfAscent;
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = metrics.getDescent() + metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static Shape drawRotatedString(String text, Graphics2D g2, double angle, float x, float y) {
        return TextUtils.drawRotatedString(text, g2, x, y, angle, x, y);
    }

    public static Shape drawRotatedString(String text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        ArgChecks.nullNotPermitted(text, "text");
        AffineTransform saved = g2.getTransform();
        Rectangle2D rect = TextUtils.getTextBounds(text, textX, textY, g2.getFontMetrics());
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        Shape bounds = rotate.createTransformedShape(rect);
        g2.transform(rotate);
        g2.drawString(text, textX, textY);
        g2.setTransform(saved);
        return bounds;
    }

    public static Shape drawRotatedString(AttributedString text, Graphics2D g2, double angle, float x, float y) {
        return TextUtils.drawRotatedString(text, g2, x, y, angle, x, y);
    }

    public static Shape drawRotatedString(AttributedString text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        ArgChecks.nullNotPermitted(text, "text");
        AffineTransform saved = g2.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        g2.transform(rotate);
        TextLayout tl = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        Rectangle2D rect = tl.getBounds();
        tl.draw(g2, textX, textY);
        g2.setTransform(saved);
        return rotate.createTransformedShape(rect);
    }

    public static Shape drawRotatedString(AttributedString text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor, Rectangle2D nonRotatedBounds) {
        ArgChecks.nullNotPermitted(text, "text");
        float[] textAdj = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor, nonRotatedBounds);
        float[] rotateAdj = TextUtils.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        return TextUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, AttributedString text, TextAnchor anchor, Rectangle2D textBounds) {
        TextLayout layout = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        float[] result = new float[3];
        float ascent = layout.getAscent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = layout.getDescent();
        float leading = layout.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHalfHeight()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -descent - leading;
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D g2, AttributedString text, TextAnchor anchor) {
        float[] result = new float[2];
        TextLayout layout = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        float ascent = layout.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = layout.getDescent();
        float leading = layout.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isLeft()) {
            xAdj = 0.0f;
        } else if (anchor.isHorizontalCenter()) {
            xAdj = (float)bounds.getWidth() / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)bounds.getWidth();
        }
        if (anchor.isTop()) {
            yAdj = descent + leading - (float)bounds.getHeight();
        } else if (anchor.isHalfHeight()) {
            yAdj = descent + leading - (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isHalfAscent()) {
            yAdj = -halfAscent;
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = descent + leading;
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }
}

