"""
vx - Unofficial Virgin America API

Usage:
  vx -u <username> -p <password>
"""


import sys
import vxapi
from docopt import docopt
from prettytable import PrettyTable

def main():
    args = docopt(__doc__, version=vxapi.__version__)
    try:
        session = vxapi.VirginAmericaWebSession(args.get('<username>'), args.get('<password>'))
        session.authenticate()
        contact_info = session.get_contact_info()
        member, activities = session.get_elevate_activity()

        member_table = PrettyTable(['name', 'value'], header=False)
        contact_table = PrettyTable(['name', 'value'], header=False)

        for t in [member_table, contact_table]:
            t.align['name'] = 'r'
            t.align['value'] = 'l'

        for key, value in member._asdict().iteritems():
            member_table.add_row([key, value])

        for key, value in contact_info._asdict().iteritems():
            contact_table.add_row([key, value])

        activity_table = PrettyTable(activities[0]._fields)
        activity_table.align['description'] = 'l'
        activity_table.align['points'] = 'r'
        if activities:
            for each in activities:
                activity_table.add_row([
                    each.activity,
                    each.date,
                    each.description,
                    each.points,
                    each.status
                    ])

        print(member_table)
        print(contact_table)
        print(activity_table)
        sys.exit(0)
    except vxapi.errors.VXException as e:
        print(e)
        sys.exit(1)
    except KeyboardInterrupt as e:
        sys.exit(1)
