import sys
import vxapi

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

if sys.argv[-1] == 'publish':
    os.system('python setup.py sdist upload')
    sys.exit()

with open('README.md') as f:
    readme = f.read()

requires = [
    'requests >= 1.2.2',
    'beautifulsoup4 >= 4.3.2',
    'docopt >= 0.6.1',
    'prettytable >= 0.7.2'
]

setup(
    name='vxapi',
    version=vxapi.__version__,
    author=vxapi.__author__,
    author_email='anthonywu@systemfu.com',
    maintainer='Anthony Wu',
    maintainer_email='anthonywu@systemfu.com',
    packages=['vxapi'],
    package_dir={'vxapi': 'vxapi'},
    scripts=[],
    entry_points={
        'console_scripts': [
            'vx = vxapi.main:main',
        ]
    },
    url='https://github.com/anthonywu/vx-api',
    license=vxapi.__license__,
    description='Unofficial Virgin America Web API',
    long_description=readme,
    install_requires=requires
)
