import os
import sys

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

README_SOURCE = 'README.md'

if sys.argv[-1] == 'publish':
    os.system('python setup.py sdist upload')
    sys.exit()
elif sys.argv[-1] == 'register':
    # if in register mode, it was triggered by `pypi_register.sh`, which seeded a converted rST readme
    README_SOURCE = 'README.rst'

readme_file = os.path.join(os.path.dirname(__file__), README_SOURCE)
license_file = os.path.join(os.path.dirname(__file__), 'LICENSE')

author = 'Anthony Wu'
email = 'anthonywu@systemfu.com'

with open(readme_file) as f:
    readme = f.read()

requires = [
    'requests >= 1.2.2',
    'beautifulsoup4 >= 4.3.2',
    'configparser == 3.3.0r2',
    'docopt >= 0.6.1',
    'prettytable >= 0.7.2'
]

setup(
    name='vxapi',
    version='0.0.8',
    author=author,
    author_email=email,
    maintainer=author,
    maintainer_email=email,
    packages=['vxapi'],
    package_dir={'vxapi': 'vxapi'},
    scripts=[],
    entry_points={
        'console_scripts': [
            'vx = vxapi.main:main',
        ]
    },
    url='https://github.com/anthonywu/vx-api',
    license=open(license_file).read(),
    description='Unofficial Virgin America Web API',
    long_description=readme,
    install_requires=requires
)
