"""
utils.py
~~~~~~~~

*vxapi* is an unofficial Python client for Virgin America Elevate accounts.

This module provides the hand-wavily reusable helpers for parsers.
All implementations are specific to Virgin America content and
are not intended for re-use outside this package.

:copyright: (c) 2014 by Anthony Wu.
:license: MIT License, see LICENSE for more details.
"""

import re

def remove_whitespace(value):
    ws = re.compile('\s')
    return ws.sub('', value)

def sanitize_text(value):
    if not value.strip():
        return None
    return value.replace(u'\xa0', ' ').strip()

def find_value(tag_instance, label_td_text, sibling_distance=1, first_line_only=False):
    target_td = tag_instance.find('td', text=label_td_text)
    for each in xrange(sibling_distance):
        target_td = target_td.find_next('td')
    target_text = target_td.text.strip()
    if first_line_only:
        target_text = target_text.split('\n')[0]
    return sanitize_text(target_text)

def find_value_tuple(tag_instance, label_td_text, sibling_distance=1):
    container_td = tag_instance.find('td', text=label_td_text).find_next('td')
    value_tds = container_td.find_all('td')
    return tuple([sanitize_text(td.text) for td in value_tds])
