![Logo](logo.gif)

![Tagline](tagline.gif)

[![PyPI version](https://badge.fury.io/py/vxapi.png)](http://badge.fury.io/py/vxapi)
[![Downloads](https://pypip.in/d/vxapi/badge.png)](https://pypi.python.org/pypi/vxapi/)
[![License](https://pypip.in/license/vxapi/badge.png)](./LICENSE)

Virgin America is my favorite airline. Its web site however... is definitely not my favorite portal.

This project aims to provide a friendly foundation for interacting with Virgin America's user data.

### Project Status

This software is alpha status! Not guaranteed to work on all user accounts. I have only my own personal account to test against, so YMMV. If you encounter problems in your account, please create a new issue or submit a pull request.


# Installation

`pip install vxapi`

Dependencies:

* `beautifulsoup4`
* `docopt`
* `prettytable`
* `requests`

# Features

* Authentication
* Elevate Membership info
* Elevate Activity History
* Registered Contact Info


# Basic Usage

    import vxapi

    session = vxapi.VirginAmericaWebSession('<your email address>', '<your password>')
    session.authenticate()
    
    # instance methods returns namedtuples
    contact_info = session.get_contact_info()
    member, activities = session.get_elevate_activity()

    print(member)
    print(contact_info)

    for each in activities:
        print(each)
        
### Sample output:

All returned types are `namedtuple` objects:

```
ElevateAccount(member_name=u'John Smith', member_number=u'1234567890', points=9021, status=u'Red')
```

```
PersonalInfo(username=u'johnsmith@example.org', member_number=u'1234567890', email=u'johnsmith@example.org (Primary)', dob=u'January 10, 1980', redress_number=None, known_traveler_number=None)
```

```
ActivityItem(activity=u'Virgin America', date=u'11/20/2013', description=u'EmiratesAirlinesPromotion-BonusPoints', points=u'+250', status=u'Earned')
ActivityItem(activity=u'Virgin America', date=u'01/01/2014', description=u'UYVAFH|SanFrancisco(SFO)-Seattle(SEA)', points=u'+315', status=u'Earned')
ActivityItem(activity=u'Virgin America', date=u'02/01/2014', description=u'UYVAFH|Seattle(SEA)-SanFrancisco(SFO)', points=u'+315', status=u'Earned')
ActivityItem(activity=u'Virgin America', date=u'02/25/2014', description=u'PremiumVisaCard-GeneralPurchasePoints', points=u'+910', status=u'Earned')
```

# Command Line Interface

A `vx` executable is available in your `$PATH`.

```
$ vx -u <username> -p <password>

+---------------+-------------+
|   member_name | John Smith  |
| member_number | 1234567890  |
|        points | 9021        |
|        status | Red         |
+---------------+-------------+
+-----------------------+-------------------------------+
|              username | johnsmith@example.org         |
|         member_number | 26604078740                   |
|                 email | jsmith@example.org (Primary)  |
|                   dob | January 10, 1980              |
|        redress_number | None                          |
| known_traveler_number | None                          |
+-----------------------+-------------------------------+
+----------------+------------+----------------------------------------+--------+----------+
|    activity    |    date    | description                            | points |  status  |
+----------------+------------+----------------------------------------+--------+----------+
| Virgin America | 11/13/2013 | IYWTEX|Seattle(SEA)-SanFrancisco(SFO)  | -5,535 | Redeemed |
| Virgin America | 11/22/2013 | EmiratesAirlinesPromotion-BonusPoints  |   +250 |  Earned  |
| Virgin America | 02/01/2014 | UYVAFH|SanFrancisco(SFO)-Seattle(SEA)  |   +315 |  Earned  |
| Virgin America | 02/04/2014 | UYVAFH|Seattle(SEA)-SanFrancisco(SFO)  |   +315 |  Earned  |
| Virgin America | 02/25/2014 | PremiumVisaCard-GeneralPurchasePoints  |   +910 |  Earned  |
+----------------+------------+----------------------------------------+--------+----------+
```
