# -*- coding: utf-8 -*-
import datetime

import wbpy

class InstrumentalData(object):

    def __init__(self):
        self.dataset = wbpy.InstrumentalDataset(self.data, self.data_stat,
            self.data_type, self.date)

class InstrumentalMonth(InstrumentalData):
    date = datetime.date(2013, 10, 1)
    data_type = "month"
    data_stat = "tas"
    data_regions = ["gbr", "esp"]
    url_a = "climatedataapi.worldbank.org/climateweb/rest/v1/country/cru/tas/month/gbr"
    response_a = [

    {
        "month": 0,
        "data": 3.5558505
    },
    {
        "month": 1,
        "data": 3.5660548
    },
    {
        "month": 2,
        "data": 5.029752
    },
    {
        "month": 3,
        "data": 7.046495
    },
    {
        "month": 4,
        "data": 9.992739
    },
    {
        "month": 5,
        "data": 12.64797
    },
    {
        "month": 6,
        "data": 14.395218
    },
    {
        "month": 7,
        "data": 14.276817
    },
    {
        "month": 8,
        "data": 12.295507
    },
    {
        "month": 9,
        "data": 9.340202
    },
    {
        "month": 10,
        "data": 5.964761
    },
    {
        "month": 11,
        "data": 4.2208977
    }

    ]

    url_b = "climatedataapi.worldbank.org/climateweb/rest/v1/country/cru/tas/month/esp"
    response_b = [

    {
        "month": 0,
        "data": 6.2650433
    },
    {
        "month": 1,
        "data": 7.335536
    },
    {
        "month": 2,
        "data": 9.484709
    },
    {
        "month": 3,
        "data": 11.475021
    },
    {
        "month": 4,
        "data": 14.807161
    },
    {
        "month": 5,
        "data": 18.776157
    },
    {
        "month": 6,
        "data": 21.889704
    },
    {
        "month": 7,
        "data": 22.015457
    },
    {
        "month": 8,
        "data": 19.039537
    },
    {
        "month": 9,
        "data": 14.4277115
    },
    {
        "month": 10,
        "data": 9.737686
    },
    {
        "month": 11,
        "data": 6.9298105
    }

    ]

    data = [
        dict(url=url_a, resp=response_a),
        dict(url=url_b, resp=response_b),
        ]


class InstrumentalYear(InstrumentalData):
    data_type = "year"
    data_stat = "tas"
    data_regions = ["bra"]
    url = "climatedataapi.worldbank.org/climateweb/rest/v1/country/cru/tas/year/bra"
    date = datetime.date(2013, 10, 1)
    response = [

    {
        "year": 1901,
        "data": 24.896547
    },
    {
        "year": 1902,
        "data": 25.09181
    },
    {
        "year": 1903,
        "data": 24.896107
    },
    {
        "year": 1904,
        "data": 24.527473
    },
    {
        "year": 1905,
        "data": 24.840496
    },
    {
        "year": 1906,
        "data": 24.773937
    },
    {
        "year": 1907,
        "data": 24.726265
    },
    {
        "year": 1908,
        "data": 24.891228
    },
    {
        "year": 1909,
        "data": 24.801495
    },
    {
        "year": 1910,
        "data": 24.767641
    },
    {
        "year": 1911,
        "data": 24.702343
    },
    {
        "year": 1912,
        "data": 24.702488
    },
    {
        "year": 1913,
        "data": 24.747656
    },
    {
        "year": 1914,
        "data": 25.001505
    },
    {
        "year": 1915,
        "data": 25.063795
    },
    {
        "year": 1916,
        "data": 24.573738
    },
    {
        "year": 1917,
        "data": 24.081936
    },
    {
        "year": 1918,
        "data": 24.573418
    },
    {
        "year": 1919,
        "data": 24.992315
    },
    {
        "year": 1920,
        "data": 24.629692
    },
    {
        "year": 1921,
        "data": 24.334965
    },
    {
        "year": 1922,
        "data": 24.371807
    },
    {
        "year": 1923,
        "data": 24.37411
    },
    {
        "year": 1924,
        "data": 24.255426
    },
    {
        "year": 1925,
        "data": 24.437939
    },
    {
        "year": 1926,
        "data": 24.772419
    },
    {
        "year": 1927,
        "data": 24.338501
    },
    {
        "year": 1928,
        "data": 24.549429
    },
    {
        "year": 1929,
        "data": 24.388468
    },
    {
        "year": 1930,
        "data": 24.692787
    },
    {
        "year": 1931,
        "data": 24.63292
    },
    {
        "year": 1932,
        "data": 24.742476
    },
    {
        "year": 1933,
        "data": 24.408184
    },
    {
        "year": 1934,
        "data": 24.358976
    },
    {
        "year": 1935,
        "data": 24.552368
    },
    {
        "year": 1936,
        "data": 24.793364
    },
    {
        "year": 1937,
        "data": 24.749926
    },
    {
        "year": 1938,
        "data": 24.633394
    },
    {
        "year": 1939,
        "data": 24.676409
    },
    {
        "year": 1940,
        "data": 24.92098
    },
    {
        "year": 1941,
        "data": 25.087818
    },
    {
        "year": 1942,
        "data": 24.88943
    },
    {
        "year": 1943,
        "data": 24.662493
    },
    {
        "year": 1944,
        "data": 24.960236
    },
    {
        "year": 1945,
        "data": 24.751871
    },
    {
        "year": 1946,
        "data": 24.82267
    },
    {
        "year": 1947,
        "data": 24.613426
    },
    {
        "year": 1948,
        "data": 24.73713
    },
    {
        "year": 1949,
        "data": 24.509995
    },
    {
        "year": 1950,
        "data": 24.528568
    },
    {
        "year": 1951,
        "data": 24.488796
    },
    {
        "year": 1952,
        "data": 24.644905
    },
    {
        "year": 1953,
        "data": 24.787127
    },
    {
        "year": 1954,
        "data": 24.857592
    },
    {
        "year": 1955,
        "data": 24.568645
    },
    {
        "year": 1956,
        "data": 24.290783
    },
    {
        "year": 1957,
        "data": 24.673687
    },
    {
        "year": 1958,
        "data": 25.121525
    },
    {
        "year": 1959,
        "data": 24.947987
    },
    {
        "year": 1960,
        "data": 24.629892
    },
    {
        "year": 1961,
        "data": 25.141964
    },
    {
        "year": 1962,
        "data": 24.80534
    },
    {
        "year": 1963,
        "data": 25.217241
    },
    {
        "year": 1964,
        "data": 24.832363
    },
    {
        "year": 1965,
        "data": 25.042736
    },
    {
        "year": 1966,
        "data": 25.179237
    },
    {
        "year": 1967,
        "data": 25.035997
    },
    {
        "year": 1968,
        "data": 24.658405
    },
    {
        "year": 1969,
        "data": 25.26417
    },
    {
        "year": 1970,
        "data": 25.130068
    },
    {
        "year": 1971,
        "data": 24.418861
    },
    {
        "year": 1972,
        "data": 24.88816
    },
    {
        "year": 1973,
        "data": 25.007069
    },
    {
        "year": 1974,
        "data": 24.396254
    },
    {
        "year": 1975,
        "data": 24.438084
    },
    {
        "year": 1976,
        "data": 24.39613
    },
    {
        "year": 1977,
        "data": 24.807856
    },
    {
        "year": 1978,
        "data": 24.677866
    },
    {
        "year": 1979,
        "data": 24.693518
    },
    {
        "year": 1980,
        "data": 24.841465
    },
    {
        "year": 1981,
        "data": 24.6487
    },
    {
        "year": 1982,
        "data": 24.80703
    },
    {
        "year": 1983,
        "data": 25.007809
    },
    {
        "year": 1984,
        "data": 24.80416
    },
    {
        "year": 1985,
        "data": 24.776478
    },
    {
        "year": 1986,
        "data": 24.891207
    },
    {
        "year": 1987,
        "data": 25.302525
    },
    {
        "year": 1988,
        "data": 25.050127
    },
    {
        "year": 1989,
        "data": 24.709227
    },
    {
        "year": 1990,
        "data": 25.069971
    },
    {
        "year": 1991,
        "data": 25.041132
    },
    {
        "year": 1992,
        "data": 24.83469
    },
    {
        "year": 1993,
        "data": 24.955845
    },
    {
        "year": 1994,
        "data": 25.072952
    },
    {
        "year": 1995,
        "data": 25.300232
    },
    {
        "year": 1996,
        "data": 25.046738
    },
    {
        "year": 1997,
        "data": 25.368227
    },
    {
        "year": 1998,
        "data": 25.68623
    },
    {
        "year": 1999,
        "data": 25.147045
    },
    {
        "year": 2000,
        "data": 25.142067
    },
    {
        "year": 2001,
        "data": 25.421627
    },
    {
        "year": 2002,
        "data": 25.65718
    },
    {
        "year": 2003,
        "data": 25.480742
    },
    {
        "year": 2004,
        "data": 25.389252
    },
    {
        "year": 2005,
        "data": 25.70073
    },
    {
        "year": 2006,
        "data": 25.494154
    },
    {
        "year": 2007,
        "data": 25.547108
    },
    {
        "year": 2008,
        "data": 25.218435
    },
    {
        "year": 2009,
        "data": 25.496075
    }

    ]

    data = [dict(url=url, resp=response)]

class InstrumentalDecade(InstrumentalData):
    date = datetime.date(2013, 10, 1)
    data_regions = ["302", 300]
    data_type = "year"
    data_stat = "pr"
    url_a = "climatedataapi.worldbank.org/climateweb/rest/v1/basin/cru/pr/decade/302"
    response_a = [

    {
        "year": 1960,
        "data": 14.410124
    },
    {
        "year": 1970,
        "data": 14.093135
    },
    {
        "year": 1980,
        "data": 15.368048
    },
    {
        "year": 1990,
        "data": 13.921389
    },
    {
        "year": 2000,
        "data": 14.790415
    }

    ]

    url_b = "climatedataapi.worldbank.org/climateweb/rest/v1/basin/cru/pr/decade/300"
    response_b = [

    {
        "year": 1960,
        "data": 14.603459
    },
    {
        "year": 1970,
        "data": 13.365872
    },
    {
        "year": 1980,
        "data": 14.364871
    },
    {
        "year": 1990,
        "data": 13.437422
    },
    {
        "year": 2000,
        "data": 13.864062
    }

    ]

    data = [
        dict(url=url_a, resp=response_a),
        dict(url=url_b, resp=response_b),
        ]


###############################################################################

class ModelledData(object):
    date = datetime.date(2013, 10, 1)

    def __init__(self):
        self.dataset = wbpy.ModelledDataset(self.data, self.data_stat,
            self.data_type, self.date)

class ModelledVarMAVG(ModelledData):
    data_type = "mavg"
    data_stat = "pr"
    url_a = "climatedataapi.worldbank.org/climateweb/rest/v1/country/mavg/pr/2020/2039/bra"
    response_a = [

    {
        "scenario": "a2",
        "gcm": "bccr_bcm2_0",
        "variable": "pr",
        "monthVals": [
            185.9119307,
            179.4912687,
            201.9563387,
            177.0913426,
            141.9072026,
            75.73041729,
            25.36077901,
            19.56156441,
            46.01293487,
            120.6003451,
            164.9925405,
            213.0492542
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "bccr_bcm2_0",
        "variable": "pr",
        "monthVals": [
            197.9507224,
            183.0097443,
            199.5386431,
            182.6175624,
            136.4165153,
            74.34675163,
            25.4942208,
            20.12643269,
            45.19111231,
            119.7389798,
            169.5458828,
            201.009392
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "cccma_cgcm3_1",
        "variable": "pr",
        "monthVals": [
            175.3399486,
            149.1324675,
            156.6887422,
            112.9897196,
            90.3763538,
            68.36105859,
            40.01162929,
            37.79072858,
            52.06211842,
            88.35877702,
            127.6709071,
            159.1258626
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "cccma_cgcm3_1",
        "variable": "pr",
        "monthVals": [
            168.9997536,
            154.1076911,
            147.6358306,
            109.7238568,
            88.58024856,
            68.53163534,
            45.75345805,
            38.45494273,
            49.26003488,
            82.52696985,
            123.251174,
            164.2477515
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "cnrm_cm3",
        "variable": "pr",
        "monthVals": [
            224.0367216,
            196.6077669,
            202.8810861,
            162.8615656,
            124.1423346,
            75.01528848,
            41.73538182,
            34.87234125,
            56.12943647,
            122.591761,
            184.4567928,
            237.0679304
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "cnrm_cm3",
        "variable": "pr",
        "monthVals": [
            222.7255998,
            192.5433291,
            202.5877503,
            164.6251101,
            123.123457,
            71.61321335,
            43.23144306,
            33.69804863,
            52.52722404,
            120.0766934,
            183.8422661,
            225.2343164
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "csiro_mk3_5",
        "variable": "pr",
        "monthVals": [
            123.9099292,
            134.3177428,
            176.361714,
            115.579037,
            54.4493068,
            22.02883396,
            12.96994837,
            8.279050239,
            7.28580286,
            29.02741012,
            91.69503348,
            110.3264769
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "csiro_mk3_5",
        "variable": "pr",
        "monthVals": [
            58.0984503,
            21.28558475,
            13.32598924,
            8.130379828,
            8.731148318,
            30.37387121,
            75.01313616,
            100.2893652,
            116.2299511,
            134.6405696,
            162.7747509,
            122.1317042
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_0",
        "variable": "pr",
        "monthVals": [
            175.78654019180925,
            180.85550789069546,
            205.31114644501392,
            159.82260847936683,
            78.65965795938745,
            27.99575065049227,
            12.85206195129054,
            7.377582594065352,
            9.763425115173986,
            25.825058591432786,
            53.439633853343786,
            122.24680474741609
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_0",
        "variable": "pr",
        "monthVals": [
            183.94907402780152,
            173.27339520496653,
            200.3642120530161,
            160.22034447595482,
            80.23321338078026,
            27.804553145882277,
            13.230271211071807,
            7.920905716319827,
            10.886190139675206,
            21.9923851234191,
            58.54730393928616,
            132.01966261647954
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_1",
        "variable": "pr",
        "monthVals": [
            170.49227280530903,
            173.329389211361,
            201.33533317643324,
            162.02831847686718,
            90.3289785743943,
            33.17926098384495,
            12.328995263990294,
            7.93924153445835,
            7.082900424977892,
            14.065740069871696,
            35.94273489344688,
            125.56228557097484
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_1",
        "variable": "pr",
        "monthVals": [
            168.61991554027512,
            171.97571761631144,
            203.76296579729865,
            159.37105061099413,
            92.5410384593826,
            32.689186168653215,
            12.070261009328004,
            7.944789895116801,
            9.272561785712266,
            14.399896152080485,
            40.47448209454984,
            121.93202089629315
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "ingv_echam4",
        "variable": "pr",
        "monthVals": [
            166.4696910276135,
            162.46309844371362,
            203.6866798231904,
            164.32273878250092,
            105.8116016008141,
            54.619003097817846,
            34.31288501538833,
            37.283133255010945,
            59.06054087580708,
            103.08986456519608,
            149.9279460147331,
            173.34109240509295
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "inmcm3_0",
        "variable": "pr",
        "monthVals": [
            115.46826895148368,
            127.40704755024606,
            160.32098967628983,
            130.55191175074867,
            96.71862547376998,
            54.774879418649675,
            34.218835564572736,
            25.47844826357251,
            25.419996999010326,
            41.00103938803942,
            66.0973295211563,
            94.25829028025821
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "inmcm3_0",
        "variable": "pr",
        "monthVals": [
            111.55949856328677,
            130.891632886089,
            149.7342006716992,
            124.20884771684203,
            92.3636894574043,
            52.283570467106216,
            35.625204076285875,
            26.322881397026674,
            25.334883170584767,
            40.174399393190704,
            64.41039206391847,
            89.73834421253434
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "ipsl_cm4",
        "variable": "pr",
        "monthVals": [
            150.53362541386542,
            141.3446232555447,
            137.57435203654364,
            99.6864473840741,
            82.77173183449418,
            60.92623971019543,
            37.00282612903225,
            19.573650038981317,
            16.43123311130715,
            29.949668965506596,
            51.39719751029006,
            106.06830679634582
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "ipsl_cm4",
        "variable": "pr",
        "monthVals": [
            133.61388111588303,
            129.52683931536671,
            136.87097512304067,
            94.50154721631245,
            81.31963721208645,
            58.166575855718904,
            32.60227375454003,
            17.682055927550607,
            18.160338390229256,
            30.914038846390316,
            48.27705176425011,
            84.76368402905548
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "miroc3_2_medres",
        "variable": "pr",
        "monthVals": [
            182.11662141834867,
            169.40805286007873,
            173.27530733886283,
            119.73198418068274,
            80.05372373403118,
            34.27586084604831,
            19.38129852679904,
            12.401512601042427,
            17.460500836500238,
            67.76783473380884,
            143.96316970133248,
            170.5258979966619
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "miroc3_2_medres",
        "variable": "pr",
        "monthVals": [
            192.71609450230758,
            178.9858303260115,
            171.48235190866566,
            126.39526998468763,
            81.88630924920773,
            36.008826532967916,
            19.575956625305995,
            13.302172150249774,
            16.162548669013002,
            72.71141690517346,
            143.97937887959438,
            180.55398724140883
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "miub_echo_g",
        "variable": "pr",
        "monthVals": [
            203.5565015151278,
            179.61802138268175,
            191.41627809641577,
            153.78631016214732,
            84.38124546538764,
            37.98118267332855,
            35.02228014950773,
            33.56598117551646,
            66.85787702557667,
            139.20611786846055,
            208.66660819431596,
            224.98628109957178
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "miub_echo_g",
        "variable": "pr",
        "monthVals": [
            203.60364280128553,
            181.17021345461401,
            189.00854941172395,
            147.85753469552964,
            88.52909664558408,
            40.48384541115692,
            33.56374035695625,
            38.33459122649312,
            73.33209990979582,
            144.95173100668626,
            202.17075872846547,
            213.3554635849518
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "mpi_echam5",
        "variable": "pr",
        "monthVals": [
            186.7423297609729,
            164.2737953691745,
            167.68470327196192,
            130.77376561460977,
            84.43172150111742,
            37.69998445942299,
            25.501181266593825,
            31.45400277066972,
            43.36605725071117,
            94.47913527165721,
            141.36949041669982,
            197.71099876301457
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "mpi_echam5",
        "variable": "pr",
        "monthVals": [
            183.58270691981116,
            153.1869132793232,
            159.253184871347,
            131.2887078344292,
            81.45115392819636,
            37.978400107431426,
            27.70810209835673,
            31.787560728881402,
            48.81270921118208,
            95.1457188697616,
            143.26599559529342,
            198.3237475504716
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "pr",
        "monthVals": [
            177.85226320585735,
            172.64225777482022,
            186.78311021345502,
            153.1142524364734,
            113.4804976513871,
            77.34739887396928,
            65.9941187031517,
            71.87010134427786,
            81.76462275053068,
            133.12707659630166,
            167.1143143999915,
            177.02394964840744
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "pr",
        "monthVals": [
            173.66443532758854,
            165.7700600582115,
            180.77776727423048,
            149.831179796081,
            110.1608521073214,
            70.0088255616304,
            60.39585603760798,
            64.24498150516098,
            78.59558229740753,
            131.6075477262494,
            162.56154479813313,
            174.80878752311105
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadcm3",
        "variable": "pr",
        "monthVals": [
            209.9184598943895,
            193.45944141711087,
            187.81292173503894,
            123.98778231376677,
            76.33221524636157,
            46.86560506545097,
            30.868594461035727,
            28.799849010019496,
            50.40172522139115,
            99.22266083571004,
            151.6815581078797,
            184.76988307143097
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "b1",
        "gcm": "ukmo_hadcm3",
        "variable": "pr",
        "monthVals": [
            195.27587704529176,
            182.5596585611383,
            188.6221342171158,
            120.52371865668492,
            68.94588942608999,
            44.4829303870293,
            27.253179311256854,
            25.420887830824665,
            55.69201742403883,
            100.64409591731918,
            148.54736491668405,
            186.71035736217937
        ],
        "fromYear": 2020,
        "toYear": 2039
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadgem1",
        "variable": "pr",
        "monthVals": [
            232.74615560380732,
            219.78910575819924,
            225.8292288579767,
            170.78439640469009,
            145.5398708972161,
            121.77445728826555,
            68.21822290956692,
            53.45959114144747,
            64.81820576802161,
            108.97130067924117,
            143.86930669515124,
            202.01667207109713
        ],
        "fromYear": 2020,
        "toYear": 2039
    }

    ]

    url_b = "climatedataapi.worldbank.org/climateweb/rest/v1/country/mavg/pr/2040/2059/bra"
    response_b = [

    {
        "scenario": "a2",
        "gcm": "bccr_bcm2_0",
        "variable": "pr",
        "monthVals": [
            195.5793736,
            182.7630994,
            206.6982444,
            182.822458,
            133.748869,
            73.93557677,
            24.10691248,
            19.37378554,
            41.63891282,
            120.1151595,
            168.3348883,
            201.3484943
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "bccr_bcm2_0",
        "variable": "pr",
        "monthVals": [
            190.4957035,
            184.7039624,
            204.3603684,
            188.3312328,
            132.1854847,
            69.1956174,
            25.20033471,
            20.23098444,
            41.317024,
            120.4716267,
            162.9740693,
            200.4123377
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "cccma_cgcm3_1",
        "variable": "pr",
        "monthVals": [
            174.1158705,
            153.1189684,
            152.1684578,
            106.4477175,
            89.21465241,
            64.90670558,
            44.71232049,
            39.24718901,
            54.51003384,
            84.56577826,
            123.4654074,
            165.6939926
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "cccma_cgcm3_1",
        "variable": "pr",
        "monthVals": [
            172.9444265,
            153.6827535,
            150.7628746,
            108.2616569,
            87.88020157,
            64.65845578,
            43.82297329,
            34.41408772,
            56.27731333,
            82.73861727,
            122.9170387,
            161.6421127
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "cnrm_cm3",
        "variable": "pr",
        "monthVals": [
            223.9531903,
            202.8911865,
            203.761117,
            162.4331613,
            130.1181652,
            70.1964507,
            40.8583795,
            32.77695039,
            53.04974719,
            124.0644688,
            202.7320487,
            241.1177347
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "cnrm_cm3",
        "variable": "pr",
        "monthVals": [
            223.9232004,
            195.9359255,
            205.34332,
            164.6127582,
            123.6955022,
            69.67589825,
            44.71079049,
            36.5183244,
            58.41852175,
            123.6383108,
            189.9872049,
            231.8704809
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "csiro_mk3_5",
        "variable": "pr",
        "monthVals": [
            128.1028041,
            130.3778071,
            171.7074925,
            120.4442326,
            54.68086443,
            20.46551372,
            12.17890431,
            7.792450681,
            7.784312321,
            29.55968472,
            84.5484612,
            102.1926787
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "csiro_mk3_5",
        "variable": "pr",
        "monthVals": [
            58.09381685,
            19.48055415,
            12.47507105,
            6.724284318,
            8.698490555,
            32.14334874,
            72.58468465,
            95.56913552,
            117.3749232,
            137.3918068,
            152.6208025,
            135.9557449
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_0",
        "variable": "pr",
        "monthVals": [
            173.7119342668932,
            180.06392927932836,
            201.31627230518822,
            159.0103258116212,
            73.9994908354951,
            27.77532489752411,
            12.751904228680567,
            6.045152632442195,
            8.671844274797806,
            22.272585215576772,
            52.367259232281214,
            116.95423081701725
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_0",
        "variable": "pr",
        "monthVals": [
            173.02116666855147,
            177.31139279359385,
            205.40076011896315,
            151.85093343362215,
            79.22908553645154,
            27.55409175647437,
            12.677099419143497,
            8.635900875779537,
            10.50944442546522,
            23.301512680870385,
            51.584673926762676,
            120.79398603563767
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_1",
        "variable": "pr",
        "monthVals": [
            166.96186678596663,
            163.16148153239308,
            189.81670114951842,
            155.81067232114856,
            92.34337001512209,
            33.81570269857165,
            12.094041314709214,
            7.394875021705342,
            6.585846839127386,
            14.134739118554329,
            35.38634177725905,
            132.97570170343766
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_1",
        "variable": "pr",
        "monthVals": [
            166.12015907323035,
            164.7296939445054,
            196.70439300285463,
            159.3320381915752,
            89.62777079997969,
            34.18769743676804,
            12.589483706828275,
            6.408542472393113,
            7.684637367904589,
            12.588371697781,
            33.65032334535062,
            105.12044023411545
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "ingv_echam4",
        "variable": "pr",
        "monthVals": [
            168.32366457450135,
            157.88773400168262,
            200.07006146001632,
            169.19064165638812,
            107.61004034290816,
            55.03835804046013,
            38.983857344196274,
            43.6232324721096,
            59.76362453681988,
            105.1267764484133,
            149.60025190674722,
            178.16392659717837
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "inmcm3_0",
        "variable": "pr",
        "monthVals": [
            109.87183782271723,
            127.01117029444065,
            151.0261448294358,
            121.51017378915093,
            87.70862175934897,
            52.92330619560907,
            35.88966798532602,
            24.6690311878878,
            25.380697744355004,
            40.823301064893606,
            63.32562997950198,
            91.46733413757299
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "inmcm3_0",
        "variable": "pr",
        "monthVals": [
            116.30661791404165,
            123.28626422548842,
            148.52570465388936,
            126.7447018243416,
            89.7245160225296,
            52.587695362294696,
            33.4645098598079,
            22.55765428473376,
            22.411286608834335,
            39.080048146713004,
            60.508108117143415,
            93.5172980211498
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "ipsl_cm4",
        "variable": "pr",
        "monthVals": [
            143.46410288220872,
            132.5949298243666,
            135.34519640429951,
            99.63227959017638,
            77.46641201596785,
            61.750559436864776,
            39.53684954336641,
            17.431796053949633,
            19.639458690408194,
            34.46238757010302,
            52.400862229608784,
            96.96971580726316
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "ipsl_cm4",
        "variable": "pr",
        "monthVals": [
            146.43157485522306,
            128.40834148160462,
            135.09223724992813,
            99.58559051235534,
            77.48086865392787,
            65.85770275299372,
            38.45951081020905,
            17.56512454572527,
            18.88081536168624,
            33.26034794680815,
            55.652653655121235,
            97.86208694066711
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "miroc3_2_medres",
        "variable": "pr",
        "monthVals": [
            190.92549190691733,
            176.86261255977738,
            168.41691193116182,
            128.42052858062618,
            84.95674765004865,
            35.114717358506994,
            18.12148742227037,
            12.567749684140574,
            12.740203656059471,
            63.758448099123044,
            147.84059094328217,
            171.79107008151317
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "miroc3_2_medres",
        "variable": "pr",
        "monthVals": [
            195.0668043119673,
            172.29306927825215,
            170.15583402709314,
            123.00083713194337,
            78.98758659004356,
            35.92240550039776,
            18.46134530901646,
            11.140726613921489,
            17.471851663517906,
            63.69252387848479,
            141.36051661353275,
            181.1016599520231
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "miub_echo_g",
        "variable": "pr",
        "monthVals": [
            208.58505932633318,
            179.837714735397,
            198.30316450744644,
            152.6327679389209,
            83.93160272278362,
            41.39092457609803,
            30.61845493369003,
            35.52396039966745,
            74.29119929802002,
            147.17049732250592,
            214.2336633395438,
            226.70715571716582
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "miub_echo_g",
        "variable": "pr",
        "monthVals": [
            206.52781237543974,
            177.74201983897703,
            190.08455382830346,
            154.43441522646998,
            85.96712466047033,
            41.489245182647046,
            32.20410120499347,
            36.21056855727497,
            71.78471469931765,
            142.96797063812772,
            215.49234481406197,
            228.1138284227602
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "mpi_echam5",
        "variable": "pr",
        "monthVals": [
            180.77466286046044,
            149.3793813622988,
            163.07831207208108,
            131.55627130403627,
            84.77701849720836,
            41.45075043027561,
            26.40401604322258,
            31.009465162774607,
            44.24003048170926,
            85.85619102661683,
            143.52129150493684,
            206.99347209085212
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "mpi_echam5",
        "variable": "pr",
        "monthVals": [
            182.76784520761888,
            156.3852298428511,
            162.6228149127028,
            126.70823523431994,
            85.58755272573022,
            39.03980338501256,
            25.965026060528565,
            33.1951651547854,
            39.89377668542464,
            89.7679369990353,
            142.43945579612637,
            199.26956275500058
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "pr",
        "monthVals": [
            179.18495546186637,
            168.96244960548088,
            180.56627003494475,
            147.49454244257745,
            106.79773883906017,
            70.85113422426691,
            62.21667733710024,
            68.55841674740657,
            77.86985095727249,
            131.45682860267306,
            163.50456629811427,
            181.24327363376818
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "pr",
        "monthVals": [
            177.37817018226025,
            169.1997076473039,
            180.15588842240402,
            150.3328246057465,
            110.77655322150748,
            74.24749105798715,
            64.98362879626876,
            65.74352470647946,
            80.09972446999093,
            131.5683678926702,
            168.53200984633992,
            177.34859966179434
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadcm3",
        "variable": "pr",
        "monthVals": [
            209.42172542928287,
            192.61752554377162,
            186.7883453559198,
            117.9764835939969,
            64.50786728078764,
            44.53443780072038,
            25.562549431184372,
            24.096708607839396,
            46.94644722579118,
            100.12003266912087,
            148.82644332984535,
            185.24377347516656
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "b1",
        "gcm": "ukmo_hadcm3",
        "variable": "pr",
        "monthVals": [
            200.37673916648623,
            186.72682979043873,
            186.52648285216472,
            125.1086215719615,
            69.69767004136803,
            42.72595884216439,
            27.515754257908124,
            28.09842532467795,
            55.95814292670152,
            100.89312554123707,
            149.08948088774804,
            184.6118687950643
        ],
        "fromYear": 2040,
        "toYear": 2059
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadgem1",
        "variable": "pr",
        "monthVals": [
            225.71320105234378,
            211.64536703106893,
            223.5107293719708,
            174.0137847081534,
            148.4994484048934,
            117.09818273534523,
            68.6275054868496,
            51.291382924190216,
            55.65796913436562,
            109.87616048343556,
            151.88583607272494,
            196.01073552023018
        ],
        "fromYear": 2040,
        "toYear": 2059
    }

    ]

    data = [
        dict(url=url_a, resp=response_a),
        dict(url=url_b, resp=response_b),
        ]

class ModelledVarAANOM(ModelledData):
    data_type = "annualanom"
    data_stat = "tas"
    url_a = "climatedataapi.worldbank.org/climateweb/rest/v1/country/annualanom/tas/2020/2039/jpn"
    response_a = [

    {
        "scenario": "a2",
        "gcm": "bccr_bcm2_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.7786479749176315
        ]
    },
    {
        "scenario": "b1",
        "gcm": "bccr_bcm2_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.8449176989103157
        ]
    },
    {
        "scenario": "a2",
        "gcm": "cccma_cgcm3_1",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.2275165758643685
        ]
    },
    {
        "scenario": "b1",
        "gcm": "cccma_cgcm3_1",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.0621217426498424
        ]
    },
    {
        "scenario": "a2",
        "gcm": "cnrm_cm3",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.1647210372120789
        ]
    },
    {
        "scenario": "b1",
        "gcm": "cnrm_cm3",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.429963764391737
        ]
    },
    {
        "scenario": "a2",
        "gcm": "csiro_mk3_5",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.2534846255653422
        ]
    },
    {
        "scenario": "b1",
        "gcm": "csiro_mk3_5",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.9668153461658157
        ]
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.0066664846322106
        ]
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.3024468672897367
        ]
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_1",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.9445158305922633
        ]
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_1",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.217628880551053
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ingv_echam4",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.721512643914342
        ]
    },
    {
        "scenario": "a2",
        "gcm": "inmcm3_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.3766808760792104
        ]
    },
    {
        "scenario": "b1",
        "gcm": "inmcm3_0",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.9657624897205526
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ipsl_cm4",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.0700354325148944
        ]
    },
    {
        "scenario": "b1",
        "gcm": "ipsl_cm4",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.1120043302838944
        ]
    },
    {
        "scenario": "a2",
        "gcm": "miroc3_2_medres",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.504642687345158
        ]
    },
    {
        "scenario": "b1",
        "gcm": "miroc3_2_medres",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.3705990439960523
        ]
    },
    {
        "scenario": "a2",
        "gcm": "miub_echo_g",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.4130586322989738
        ]
    },
    {
        "scenario": "b1",
        "gcm": "miub_echo_g",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.0317559493214734
        ]
    },
    {
        "scenario": "a2",
        "gcm": "mpi_echam5",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.6037645841900264
        ]
    },
    {
        "scenario": "b1",
        "gcm": "mpi_echam5",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.6843181409334473
        ]
    },
    {
        "scenario": "a2",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            0.8660503186673421
        ]
    },
    {
        "scenario": "b1",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.0293233771075527
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadcm3",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.3679215280637105
        ]
    },
    {
        "scenario": "b1",
        "gcm": "ukmo_hadcm3",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.2086350290398158
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadgem1",
        "variable": "tas",
        "fromYear": 2020,
        "toYear": 2039,
        "annualData": [
            1.3869098864103686
        ]
    }

    ]

    url_b = "climatedataapi.worldbank.org/climateweb/rest/v1/country/annualanom/tas/2060/2079/jpn"
    response_b = [

    {
        "scenario": "a2",
        "gcm": "bccr_bcm2_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.255086798416842
        ]
    },
    {
        "scenario": "b1",
        "gcm": "bccr_bcm2_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.4150808233955265
        ]
    },
    {
        "scenario": "a2",
        "gcm": "cccma_cgcm3_1",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.6754439504526317
        ]
    },
    {
        "scenario": "b1",
        "gcm": "cccma_cgcm3_1",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.70144974558079
        ]
    },
    {
        "scenario": "a2",
        "gcm": "cnrm_cm3",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            3.0710481342507894
        ]
    },
    {
        "scenario": "b1",
        "gcm": "cnrm_cm3",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.1501922607426316
        ]
    },
    {
        "scenario": "a2",
        "gcm": "csiro_mk3_5",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.567907232987895
        ]
    },
    {
        "scenario": "b1",
        "gcm": "csiro_mk3_5",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.9166894210021053
        ]
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.951608758223684
        ]
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.52318854080921
        ]
    },
    {
        "scenario": "a2",
        "gcm": "gfdl_cm2_1",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.5611435739621053
        ]
    },
    {
        "scenario": "b1",
        "gcm": "gfdl_cm2_1",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.999645835474737
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ingv_echam4",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.9863618549544735
        ]
    },
    {
        "scenario": "a2",
        "gcm": "inmcm3_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.5045936986015787
        ]
    },
    {
        "scenario": "b1",
        "gcm": "inmcm3_0",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.8178285297599999
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ipsl_cm4",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.819903725071842
        ]
    },
    {
        "scenario": "b1",
        "gcm": "ipsl_cm4",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.261749267578158
        ]
    },
    {
        "scenario": "a2",
        "gcm": "miroc3_2_medres",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            3.192606072676842
        ]
    },
    {
        "scenario": "b1",
        "gcm": "miroc3_2_medres",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.301438181024474
        ]
    },
    {
        "scenario": "a2",
        "gcm": "miub_echo_g",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            3.030264603464474
        ]
    },
    {
        "scenario": "b1",
        "gcm": "miub_echo_g",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.4906086168792108
        ]
    },
    {
        "scenario": "a2",
        "gcm": "mpi_echam5",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.403093839946579
        ]
    },
    {
        "scenario": "b1",
        "gcm": "mpi_echam5",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.0043094032678943
        ]
    },
    {
        "scenario": "a2",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.223550093801053
        ]
    },
    {
        "scenario": "b1",
        "gcm": "mri_cgcm2_3_2a",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            1.9238570363900005
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadcm3",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            3.2231140136713154
        ]
    },
    {
        "scenario": "b1",
        "gcm": "ukmo_hadcm3",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            2.411973652086579
        ]
    },
    {
        "scenario": "a2",
        "gcm": "ukmo_hadgem1",
        "variable": "tas",
        "fromYear": 2060,
        "toYear": 2079,
        "annualData": [
            3.096522281043947
        ]
    }

    ]

    url_c = "climatedataapi.worldbank.org/climateweb/rest/v1/country/annualanom/tas/ensemble/2060/2079/jpn"
    response_c = [

    {
        "scenario": "a2",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            2.181849266353948
        ],
        "percentile": 10
    },
    {
        "scenario": "b1",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            2.492199715814999
        ],
        "percentile": 90
    },
    {
        "scenario": "a2",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            3.2158861599476314
        ],
        "percentile": 90
    },
    {
        "scenario": "b1",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            2.1578240645557893
        ],
        "percentile": 50
    },
    {
        "scenario": "b1",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            1.6806745121352629
        ],
        "percentile": 10
    },
    {
        "scenario": "a2",
        "fromYear": 2060,
        "toYear": 2079,
        "annualVal": [
            2.7747529682360526
        ],
        "percentile": 50
    }

    ]

    data = [
        dict(url=url_a, resp=response_a),
        dict(url=url_b, resp=response_b),
        dict(url=url_c, resp=response_c),
        ]


class ModelledStat(ModelledData):
    data_type = "mavg"
    data_stat = "tmin_means"
    url_a = "climatedataapi.worldbank.org/climateweb/rest/v1/country/mavg/ensemble/tmin_means/2046/2065/aus"
    response_a = [

    {
        "scenario": "b1",
        "monthVals": [
            25.782083803811982,
            25.634608734978226,
            24.114042061695542,
            21.46466295453778,
            18.052794096204266,
            15.101227853563024,
            13.606312052408395,
            14.576856708530173,
            17.27432642406916,
            20.47667560577746,
            23.306786077290358,
            25.037286224368643
        ],
        "percentile": 90,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "b1",
        "monthVals": [
            24.041002031960893,
            23.880588344994475,
            22.67146384769044,
            19.886640076104676,
            16.046275778875685,
            13.048262530434489,
            11.696615708667647,
            13.040205686357462,
            15.58095425287858,
            18.5749880472795,
            21.244146103331047,
            23.116800172595788
        ],
        "percentile": 50,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            21.581415437062162,
            21.752888304394073,
            20.168976287839964,
            17.458623985713725,
            14.199868598513163,
            11.072101651297425,
            9.729770958159154,
            10.630333902571474,
            13.256081190110892,
            16.404454576706183,
            18.974266628689783,
            20.477993464997603
        ],
        "percentile": 10,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "b1",
        "monthVals": [
            21.10662211948022,
            21.197347937689965,
            19.804292882284805,
            16.986286434598355,
            13.64291070302453,
            10.435863842435202,
            9.062306179735174,
            10.143603411780752,
            12.577768972185863,
            15.805609361862539,
            18.311742615171077,
            19.940080189175784
        ],
        "percentile": 10,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            26.199926584035097,
            26.08030697292755,
            24.52425097995068,
            21.83637115902157,
            18.305653300815962,
            15.245683038498221,
            14.1148452737556,
            14.981919038562001,
            17.592039754656533,
            20.77404207865334,
            23.537432471381152,
            25.52079916636054
        ],
        "percentile": 90,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            24.408924450345864,
            24.38896102905363,
            23.18872515360395,
            20.491847644382446,
            16.720330077275246,
            13.489942398072039,
            12.157988754908306,
            13.409644813534802,
            16.035596533884487,
            19.10823663923685,
            21.69680718528129,
            23.609122865465135
        ],
        "percentile": 50,
        "fromYear": 2046,
        "toYear": 2065
    }

    ]

    url_b = "climatedataapi.worldbank.org/climateweb/rest/v1/country/mavg/ensemble/tmin_means/2046/2065/nzl"
    response_b = [

    {
        "scenario": "b1",
        "monthVals": [
            16.401694195610716,
            17.008454118460715,
            16.4645305361,
            14.840376615530001,
            13.021743570053214,
            11.583745241169643,
            10.744972620690714,
            10.453464831625,
            10.672451002253927,
            11.231809565002859,
            12.463586228230714,
            14.541015999650355
        ],
        "percentile": 90,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "b1",
        "monthVals": [
            15.367983545582144,
            15.912106343678575,
            15.328311852042857,
            13.773818765363572,
            11.987482070920711,
            10.564060296334999,
            9.669650009702858,
            9.45698642731107,
            9.854635425973214,
            10.563139268330714,
            11.863610131406073,
            13.69362272534464
        ],
        "percentile": 50,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            13.693805830807142,
            13.978051424030355,
            13.31321934291607,
            11.869024361892144,
            10.267027071541426,
            8.805862699235357,
            8.189702902521427,
            8.144503423142499,
            8.752993822099999,
            9.377128192358573,
            10.597079311097856,
            12.226380586624286
        ],
        "percentile": 10,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "b1",
        "monthVals": [
            13.285540955404642,
            13.639775242117853,
            13.000142897872857,
            11.565237573215358,
            9.875808937212144,
            8.596301266128929,
            7.842985459735716,
            7.787801623345355,
            8.381649102487142,
            9.006317768784285,
            10.233347552166785,
            11.953954969136428
        ],
        "percentile": 10,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            16.686951330732143,
            17.245020525803575,
            16.69483978407143,
            15.03799993651893,
            13.24689153262714,
            11.917718172072856,
            11.048641289976787,
            10.828486732078215,
            10.977341600833572,
            11.547211255340002,
            12.763983215594646,
            14.979195049835715
        ],
        "percentile": 90,
        "fromYear": 2046,
        "toYear": 2065
    },
    {
        "scenario": "a2",
        "monthVals": [
            15.671809571128566,
            16.161321912496433,
            15.561991895942857,
            14.043036835538215,
            12.255052345144287,
            10.822844896997498,
            9.95973421846,
            9.724211062704285,
            10.008326768875358,
            10.813060607225713,
            12.155830349238927,
            14.113970484054287
        ],
        "percentile": 50,
        "fromYear": 2046,
        "toYear": 2065
    }

    ]

    data = [
        dict(url=url_a, resp=response_a),
        dict(url=url_b, resp=response_b),
        ]
