from setuptools import setup, find_packages
from wdmmg import __version__

setup(
    name='wdmmg',
    version=__version__,
    description='Code for http://wheredoesmymoneygo.org/',
    author='Open Knowledge Foundation',
    author_email='info@okfn.org',
    url='',
    install_requires=[
        "Pylons>=0.9.7,<=0.9.7.99",
        "SQLAlchemy>=0.5,<=0.5.99",
        "Genshi>=0.5,<=0.5.99",
        "gdata>=2.0.10",
        "solrpy>=0.9.1",
    ],
    packages=find_packages(exclude=['ez_setup']),
    include_package_data=True,
    test_suite='nose.collector',
    package_data={'wdmmg': ['i18n/*/LC_MESSAGES/*.mo']},
    #message_extractors={'wdmmg': [
    #        ('**.py', 'python', None),
    #        ('public/**', 'ignore', None)]},
    zip_safe=False,
    paster_plugins=['PasteScript', 'Pylons'],
    entry_points="""
    [paste.app_factory]
    main = wdmmg.config.middleware:make_app

    [paste.app_install]
    main = pylons.util:PylonsInstaller

    [paste.paster_command]
    db = wdmmg.lib.cli:ManageDb
    fixtures = wdmmg.lib.cli:Fixtures
    load = wdmmg.lib.cli:Load
    sitetest = wdmmg.lib.cli:SiteTest
    solr = wdmmg.lib.cli:Solr

    """,
)
