import logging

from pylons import request, response, session, tmpl_context as c, url
from pylons.controllers.util import abort, redirect

from wdmmg.lib.base import BaseController, render
from wdmmg.lib.helpers import Page
from wdmmg import model

log = logging.getLogger(__name__)

class DatasetController(BaseController):

    def index(self):
        c.limit = int(request.params.get('limit', '100')) # TODO: Nicer error message.
        c.results = model.Session.query(model.Dataset)[:c.limit]
        return render('dataset/index.html')

    def view(self, name_or_id=None):
        c.row = self.get_by_name_or_id(model.Dataset, name_or_id)
        c.num_entries = (model.Session.query(model.Entry)
            .filter_by(dataset_=c.row)
            ).count()
        return render('dataset/view.html')

    def entries(self, name_or_id=None):
        c.dataset_ = self.get_by_name_or_id(model.Dataset, name_or_id)
        query = model.Session.query(model.Entry).filter_by(dataset_=c.dataset_)
        c.page = Page(
            collection=query,
            page=int(request.params.get('page', 1)),
            items_per_page=c.items_per_page,
            item_count=query.count()
        )
        return render('dataset/entries.html')

