import logging

from pylons import request, response, session, tmpl_context as c, url
from pylons.controllers.util import abort, redirect

from wdmmg.lib.base import BaseController, render
from wdmmg.lib.helpers import Page
from wdmmg.lib.helpers import dept_name_to_wdtk_identifier
from wdmmg import model

log = logging.getLogger(__name__)

class EntryController(BaseController):
    def index(self):
        query = model.Session.query(model.Entry)
        c.page = Page(
            collection=query,
            page=int(request.params.get('page', 1)),
            items_per_page=c.items_per_page,
            item_count=query.count(),
        )
        return render('entry/index.html')

    def view(self, id_=None):
        if not id_.isdigit():
            abort(404, 'Sorry, entries must have a numeric code!')
        c.row = self.get_by_id(model.Entry, id_)
        if not c.row:
            abort(404, 'Sorry, there is no entry with code %r'%code)
        if 'departments' in c.row.dataset_.name:
            c.show_foi = True
        else:
            c.show_foi = False
        c.classification = {} # Map from Key to EnumerationValue.
        for ci in c.row.classificationitems:
            if ci.value.key.name=='from':
                c.entry_from = ci.value
                c.wdtk_name = dept_name_to_wdtk_identifier(c.entry_from)
            elif ci.value.key.name=='to':
                c.entry_to = ci.value
            elif ci.value.key.name=='time':
                c.entry_time = ci.value
            else:
                c.classification[ci.value.key] = ci.value
        return render('entry/view.html')

