from pylons import config

import wdmmg
from wdmmg.lib.solrhelp import solr_connection


class Globals(object):
    """Globals acts as a container for objects available throughout the
    life of the application

    """

    def __init__(self):
        """One instance of Globals is created during application
        initialization and is available during requests via the
        'app_globals' variable

        """
        self.solr = solr_connection()
        self.site_title = config.get('wdmmg.site_title', 'Data Store')
        self.site_logo = config.get('wdmmg.site_logo', '/images/datastore-logo.png')
        self.__version__ = wdmmg.__version__
        self.default_dataset = config.get('wdmmg.default_dataset', u'cra')
        self.banner_headline = config.get('wdmmg.banner_headline', '')

