# -*- coding: utf8 -*-
"""Helper functions

Consists of functions to typically be used within templates, but also
available to Controllers. This module is available to templates as 'h'.
"""
from webhelpers.html import escape, HTML, literal, url_escape
from webhelpers.html.tags import *
from webhelpers import paginate
from webhelpers.markdown import markdown as _markdown
def markdown(*args, **kwargs):
    return literal(_markdown(*args, **kwargs))

class Page(paginate.Page):
    '''Follow ckan setup.'''

    # Curry the pager method of the webhelpers.paginate.Page class, so we have
    # our custom layout set as default.
    def pager(self, *args, **kwargs):
        kwargs.update(
            format="<div class='pager'>$link_previous ~2~ $link_next</div>",
            symbol_previous=u'\xab Prev', symbol_next=u'Next \xbb'
        )
        return super(Page, self).pager(*args, **kwargs)


import wdmmg.model as model
from pylons import url
def render_value(keyvalue):
    enumval = keyvalue.enumeration_value
    if enumval:
        return link_to('%s (%s)' % (enumval.name, enumval.code),
                url(controller='enumeration_value',
                    name_or_id=keyvalue.key.name,
                    action='view', code=enumval.code)
                )
    else:
        return keyvalue.value

def convert_search_result(result):
    entry_id = result.get('id', '')
    entry = (model.Session.query(model.Entry)
        .filter_by(id=entry_id)
        ).first()
    # HACK: to allow us to display remove search results
    # just got data from solr with no record in local db
    if entry is None:
        return result
    return entry.as_big_dict()

def format_number(number):
    '''Format a number with m,b,k etc.

    '''
    if not number:
        return ''
    # round to 3 significant figures
    tnumber = float('%.2e' % number)
    if abs(tnumber) > 1e9:
        return '%sb' % (tnumber / 1e9)
    elif abs(tnumber) > 1e6:
        return '%sm' % (tnumber / 1e6)
    elif abs(tnumber) > 1e3:
        return '%sk' % (tnumber / 1e3)
    else:
        return '%s' % number


def format_number_with_commas(number):
    '''Format a number with commas.

    NB: will convert to integer e.g. 2010.13 -> 2,010
    '''
    s = '%d' % number
    groups = []
    while s and s[-1].isdigit():
        groups.append(s[-3:])
        s = s[:-3]
    return s + ','.join(reversed(groups))

def dept_name_to_wdtk_identifier(dept_name):
    '''
    Converts a department name from our naming scheme
    to the WDTK naming scheme, for making FOI requests.
    '''
    identifiers = { 
       'attorney-generals-office': 'attorney_generals_office',
       'cabinet-office': 'cabinet_office',
       'department-for-business-innovation-and-skills': 'bis',
       'department-for-communities-and-local-government': 'dclg',
       'department-for-culture-media-and-sport': 'dcms',
       'department-for-education': 'dfe',
       'department-for-energy-climate-change ': 'decc',
       'department-for-international-development': 'dfid',
       'department-for-transport': 'dft',
       'department-for-work-and-pensions': 'dwp',
       'department-of-health': 'dh',
       'department-of-the-environment-food-rural-affairs': 'defra',
       'foreign-and-commonwealth-office': 'fco',
       'government-equalities-office': 'government_equalities_office',
       'hm-revenue-customs': 'hm',
       'hm-treasury': 'hm_treasury',
       'home-office': 'home_office',
       'ministry-of-defence': 'mod',
       'ministry-of-justice': 'moj',
       'northern-ireland-office': 'nio',
       'scotland-office': 'scotland_office',
       'wales-office': 'wales_office_swyddfa_cymru',
    }
    try:
        wdtk_identifier = identifiers['dept_name'] 
    except:
        wdtk_identifier = 'unknown'
    return wdtk_identifier
