from sqlalchemy import Table, Column, ForeignKey
from sqlalchemy.types import *
from sqlalchemy.orm import mapper, relation, backref

import meta
from base import DomainObject, PublishedDomainObject
from atp import Entry
from keyvalue import EnumerationValue, add_keyvalues


class ClassificationItem(DomainObject):
    pass

table_classification_item = Table('classification_item', meta.metadata,
    Column('id', Integer, primary_key=True),
    Column('entry_id', Integer, ForeignKey('entry.id'), index=True),
    Column('value_id', Integer, ForeignKey('enumeration_value.id'), index=True)
)

mapper(ClassificationItem, table_classification_item, properties={
        'entry': relation(Entry, backref=backref('classificationitems')),
        'value': relation(EnumerationValue, backref=backref('classificationitems')),
    },
    order_by=table_classification_item.c.entry_id
)


# add_keyvalues(Classification)

# TODO: Use an attribute_mapped_collection for Classification.items.

