from wdmmg.tests import *
import wdmmg.model as model

class TestRestController(TestController):
    @classmethod
    def setup_class(self):
        Fixtures.setup()
    
    @classmethod
    def teardown_class(self):
        Fixtures.teardown()
    
    def test_index(self):
        response = self.app.get(url(controller='rest', action='index'))
        for word in ['dataset', 'entry', 'key', 'value']:
            assert word in response, response
    
    def test_dataset(self):
        response = self.app.get(url(controller='rest', action='dataset',
            name_or_id=Fixtures.dataset_.name))
        assert '"id":' in response, response
        assert '"name": "cra"' in response, response
    
    def test_entry(self):
        example = (model.Session.query(model.Entry)
            .filter_by(dataset_=Fixtures.dataset_)
            ).first()
        response = self.app.get(url(controller='rest', action='entry',
            id_=example.id))
        assert '"id":' in response, response
        assert '"cofog1":' in response, response
        assert '"from_code":' in response, response
        assert '"Dept032"' in response, response

    def test_key(self):
        response = self.app.get(url(controller='rest', action='key',
            name_or_id=Fixtures.cofog2.name))
        assert '"id":' in response, response
        assert '"enumeration_values":' in response, response
        assert '"04.5":' in response, response
        assert '"parent":' in response, response

    def test_enumeration_value(self):
        example = (model.Session.query(model.EnumerationValue)
            .filter_by(key=Fixtures.region)
            ).first()
        response = self.app.get(url(controller='rest', action='enumeration_value',
            name_or_id=Fixtures.region.name, code=example.code))
        assert '"id":' in response, response
        assert '"code":' in response, response
        assert '"population2006":' in response, response

