import pkg_resources, json

import wdmmg.model as model
from wdmmgext.load import cofog
from wdmmgext.load import cra2010
import os

class TestCRA(object):
    @classmethod
    def setup_class(self):
        model.repo.delete_all()
        model.Session.remove()
        cofog.load_file(pkg_resources.resource_stream('wdmmg', 'tests/COFOG_english_structure_short_2010.txt'))
        cofog_mapper = cra2010.CofogMapper(json.load(pkg_resources.resource_stream('wdmmg', 'tests/cofog_map_short_2010.json')))
        filename = os.path.abspath('wdmmg/tests/cra_2010_db_short.csv')
        cra2010.load_file(filename, cofog_mapper, commit_every=10)
        model.Session.commit()
        model.Session.remove()

    @classmethod
    def teardown_class(self):
        model.repo.delete_all()
        model.Session.commit()
        model.Session.remove()

	# check dataset exists
    def test_01_dataset(self):
        out = (model.Session.query(model.Dataset)
            .filter_by(name=u'cra')
            ).first()
        assert out, out

	# get all our keys, and check values exist for them
    # APS: why don't we check for the key 'to' at this point?   
    def test_02_classification(self):
        for key_name in [u'from', u'time', u'pog', u'cap_or_cur', u'region',
                u'cofog1', u'cofog2']:
            key = model.Session.query(model.Key).filter_by(name=key_name).first()
            assert key, key_name
            count = (model.Session.query(model.ClassificationItem)
                .join(model.EnumerationValue)
                .filter_by(key=key)
                ).count()
            assert count, (key_name, count)

    # check there are some entries and none of them are null
    def test_03_entry(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=u'cra')
            ).one()
        count = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).count()
        assert count, 'There are no Entries'
        assert not (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .filter_by(amount=None)
            ).first(), 'Some Entries have NULL amounts'
    
    # look for a 'to' field on the first entry in the dataset
    def test_04_entry_to(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=u'cra')
            ).one()
        txn = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).first()
        classif = txn.classification_as_dict()
        assert classif['to'] == u'society'

