import json
import os
import pkg_resources
import wdmmg.model as model
from wdmmgext.load import departments
from wdmmgext.load import department

class TestDepartments(object):

    @classmethod
    def setup_class(self):
        model.repo.delete_all()
        model.Session.remove()
        self.name = department.dataset_name
        filepath = 'wdmmg/tests/departmental-test-AGO-TSol-05-May-2010-after-12th.csv'
        test_file = os.path.abspath(filepath)
        department.load_file(test_file, 'Attorney General\'s Office', \
                'Treasury Solicitor\'s Department', commit_every=10)
        model.Session.commit()
        model.Session.remove()

    @classmethod
    def teardown_class(self):
        model.repo.delete_all()
        model.Session.commit()
        model.Session.remove()

    # check dataset exists
    def test_01_dataset(self):
        out = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).first()
        assert out, out

    # Get all our keys, and check values exist for them.
    def test_02_classification(self):
        for key_name in [u'from', u'time', u'filename', u'sub_unit',
                u'department_family', u'entity', u'expense_type', u'expense_area',
                u'transaction_number']:
            key = model.Session.query(model.Key).filter_by(name=key_name).first()
            assert key, key_name
            count = (model.Session.query(model.ClassificationItem)
                .join(model.EnumerationValue)
                .filter_by(key=key)
                ).count()
            assert count, (key_name, count)

    # Check there are some entries and none of them are null
    def test_03_entry(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        count = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).count()
        assert count, 'There are no Entries'
        assert not (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .filter_by(amount=None)
            ).first(), 'Some Entries have NULL amounts'
    
    # Look for a 'to' field on the first entry in the dataset.
    def test_04_entry_to(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        txn = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).first()
        classif = txn.classification_as_dict()
        print classif['to']
        assert classif['to'] == 'altodigital-uk-limited'

    # Check that empty values don't get loaded.
    def test_05_entry_empty(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        transaction_key = (model.Session.query(model.Key)
            .filter_by(name=u'transaction_number')).first() 
        txn = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(key_id=transaction_key.id,name=u'419415')
            ).first()
        classif = txn.classification_as_dict() 
        assert not 'department_family' in classif.keys()

    # Check we have some descriptions in the notes fields,
    # and check notes aren't being added for rows without descriptions.
    def test_06_descriptions(self):
        dataset_ = (model.Session.query(model.Dataset)
                    .filter_by(name=self.name)
                     ).one()
        transaction_key = (model.Session.query(model.Key)
                    .filter_by(name=u'transaction_number')).first() 
        txn_with_notes = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(key_id=transaction_key.id,name=u'119999')
            ).first()
        txn_without_notes = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(key_id=transaction_key.id,name=u'419415')
            ).first()
        assert 'Another dummy spending description' in txn_with_notes.notes
        assert not txn_without_notes.notes

    # Check we have some descriptions in the notes fields,
    # and check notes aren't being added for rows without descriptions.
    def test_07_dates(self):
        dataset_ = (model.Session.query(model.Dataset)
                    .filter_by(name=self.name)
                     ).one()
        transaction_key = (model.Session.query(model.Key)
                    .filter_by(name=u'transaction_number')).first() 
        txn_with_excel_date = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(key_id=transaction_key.id,name=u'130000')
            ).first()
        txn_without_excel_date = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(key_id=transaction_key.id,name=u'120000')
            ).first()
        classif_with_excel_date = txn_with_excel_date.classification_as_dict()
        classif_without_excel_date = \
                    txn_without_excel_date.classification_as_dict()
        assert '26/8/2010' in classif_with_excel_date['time'] 
        assert '17/05/2010' in classif_without_excel_date['time'] 