"""Routes configuration

The more specific and detailed routes should be defined first so they
may take precedent over the more generic routes. For more information
refer to the routes manual at http://routes.groovie.org/docs/
"""
from pylons import config
from routes import Mapper

def make_map():
    """Create, configure and return the routes Mapper"""
    map = Mapper(directory=config['pylons.paths']['controllers'],
                 always_scan=config['debug'], explicit=True)
    map.minimization = False

    # The ErrorController route (handles 404/500 error pages); it should
    # likely stay at the top, ensuring it can always be resolved
    map.connect('/error/{action}', controller='error')
    map.connect('/error/{action}/{id}', controller='error')

    # CUSTOM ROUTES HERE

    map.connect('home', '/', controller='home', action='index')

    map.connect('/25kspending', controller='home', action='govspending')

    map.connect('search', '/search', controller='search', action='index')
    
    map.connect('/aggregate', controller='aggregate', action='view')

    map.connect('/dataset', controller='dataset', action='index')
    map.connect('/dataset/{name_or_id}', controller='dataset', action='view')
    map.connect('/dataset/{name_or_id}/{action}', controller='dataset')

    map.connect('/entry', controller='entry', action='index')
    map.connect('/entry/{id_}', controller='entry', action='view')
    map.connect('/entry/{id_}/{action}', controller='entry')

    map.connect('/key', controller='key', action='index')
    map.connect('/key/{name_or_id}', controller='key', action='view')
    map.connect('/key/{name_or_id}/{action}', controller='key')
    map.connect('/key/{name_or_id}/value/{code}', controller='enumeration_value', action='view')
    map.connect('/key/{name_or_id}/value/{code}/{action}', controller='enumeration_value')

    # Deprecated.
    map.connect('/enumeration_value/{id_}', controller='enumeration_value', action='view_id')

    map.connect('/api', controller='api', action='index')
    map.connect('/api/search', controller='api', action='search')
    map.connect('/api/aggregate', controller='api', action='aggregate')
    map.connect('/api/mytax', controller='api', action='mytax')

    map.connect('/api/rest', controller='rest', action='index')
    map.connect('/api/rest/dataset/{name_or_id}', controller='rest', action='dataset')
    map.connect('/api/rest/entry/{id_}', controller='rest', action='entry')
    map.connect('/api/rest/key/{name_or_id}', controller='rest', action='key')
    map.connect('/api/rest/key/{name_or_id}/value/{code}', controller='rest', action='enumeration_value')
    map.connect('/api/rest/enumeration_value/{id_}', controller='rest', action='enumeration_value_id')

    map.redirect('/*(url)/', '/{url}', 
        _redirect_code='301 Moved Permanently') 
    return map
