import logging

from pylons import request, response, session, tmpl_context as c, url, app_globals
from pylons.controllers.util import abort, redirect
from sqlalchemy import desc

from wdmmg.lib.base import BaseController, render
from wdmmg.lib.helpers import Page
from wdmmg import model

log = logging.getLogger(__name__)

class EnumerationValueController(BaseController):
    '''
    EnumerationValues are usually specified using a Key and a code.
    The Key is usually specified by `name`, though an `id` is also accepted.
    For backwards EnumerationValues can also be specified by `id`.
    '''

    def view_id(self, id_=None):
        '''Deprecated.'''
        c.row = self.get_by_id(model.EnumerationValue, id_)
        c.key = c.row.key
        return render('enumeration_value/view.html')

    def view(self, name_or_id=None, code=None):
        '''
        name_or_id - a `Key.name` or `Key.id`.
        code - an `EnumerationValue.code`.
        '''
        c.key = self.get_by_name_or_id(model.Key, name_or_id)
        c.row = (model.Session.query(model.EnumerationValue)
            .filter_by(key=c.key)
            .filter_by(code=code)
            ).first()
        if not c.row:
            abort(404, 'No record with code %r'%code)
        query = (model.Session.query(model.Entry)
            .join(model.ClassificationItem)
            .join(model.EnumerationValue)
            .filter_by(id=c.row.id)
            .order_by(desc(model.Entry.amount))
            )
        c.amounts = self._get_totals()
        c.page = Page(
            collection=query,
            page=int(request.params.get('page', 1)),
            items_per_page=c.items_per_page,
            item_count=query.count(),
        )
        return render('enumeration_value/view.html')

    def _get_totals(self):
        keyname = c.key.name
        if c.key.name in ['to','from']:
            keyname += '_code'
        q = '%s:"%s"' % (keyname, c.row.code)
        query = app_globals.solr.query(q, stats='true', stats_field='amount',
                stats_facet='time_norm', rows=0)
        try:
            amountfield = query.stats['stats_fields']['amount']
            c.total = amountfield['sum']
            results = []
            for timenorm, val in amountfield['facets']['time_norm'].items():
                results.append([timenorm, val['sum']])
            return sorted(results)
        except:
            return []

