import logging

from pylons import request, response, session, tmpl_context as c, url, app_globals
from pylons.controllers.util import abort, redirect_to

from wdmmg.lib.base import BaseController, render
from wdmmg.lib.helpers import Page
import wdmmg.model as model

log = logging.getLogger(__name__)

class SearchController(BaseController):
    def index(self):
        c.q = request.params.get('q', None)

        c.dataset_options = [ ('*', 'All') ] +  [
            (x.name,x.name) for x in model.Session.query(model.Dataset).all()]
        c.dataset = request.params.get('dataset', '*')

        c.facet_1_options = [ ('from','from'), ('to','to'), (None, '') ]
        c.facet_1 = request.params.get('facet_1', None)

        page=int(request.params.get('page', 1))
        start = (page-1) * c.items_per_page
        ourq = c.q if c.q else '*'
        kwargs = {}
        if c.facet_1:
            kwargs['facet'] = 'true'
            kwargs['facet_field'] = c.facet_1 + '_facet'
            kwargs['facet_mincount'] = 1
            kwargs['facet_limit'] = 50
        query = app_globals.solr.query(ourq, fq='dataset:%s' % c.dataset, rows=c.items_per_page,
                start=start, sort='score desc, amount desc', **kwargs)
        c.results = query.results
        if c.q and query.numFound > 0:
            c.amounts = self._get_totals()
        if c.facet_1:
            c.facet_counts = query.facet_counts['facet_fields'][c.facet_1 + '_facet']
        c.page = Page(
            collection=c.results,
            page=page,
            items_per_page=c.items_per_page,
            item_count=query.numFound,
            q=c.q, # Preserve `q` when the user clicks 'next' or 'previous'.
        )
        return render('search/index.html')

    def _get_totals(self):
        query = app_globals.solr.query(c.q, fq='dataset:%s' % c.dataset, stats='true', stats_field='amount',
                stats_facet='time_norm', rows=0)
        amountfield = query.stats['stats_fields']['amount']
        c.total = amountfield['sum']
        results = []
        for timenorm, val in amountfield['facets']['time_norm'].items():
            results.append([timenorm, val['sum']])
        return sorted(results)

