import wdmmg.model as model
from wdmmg.tests import Fixtures

class TestAsDict(object):
    @classmethod
    def setup_class(self):
        Fixtures.setup()
    
    @classmethod
    def teardown_class(self):
        Fixtures.teardown()
    
    def test_dataset(self):
        ans = Fixtures.dataset_.as_big_dict()
        for field in ['id', 'name', 'currency', 'metadata', 'notes']:
            assert field in ans, ans
    
    def test_entry(self):
        ans = (model.Session.query(model.Entry)
            .filter_by(dataset_=Fixtures.dataset_)
            ).first().as_big_dict()
        for field in ['id', 'dataset', 'amount', 'notes', 'currency', 'cofog1']:
            assert field in ans, (field, ans)

    def test_key(self):
        ans = Fixtures.cofog2.as_big_dict()
        for field in ['id', 'name', 'notes', 'enumeration_values', 'keyvalues']:
            assert field in ans, ans
        evs = ans['enumeration_values']
        for code in [u'04.5']:
            assert code in evs, evs
            for field in ['id', 'key_id', 'code', 'name', 'keyvalues']:
                assert field in evs[code], evs[code]
            for key in ['parent']:
                assert key in evs[code]['keyvalues'], evs[code]
        for key in ['parent']:
            assert key in ans['keyvalues'], ans

    def test_enumeration_value(self):
        ans = (model.Session.query(model.EnumerationValue)
            .filter_by(key=Fixtures.region)
            ).first().as_big_dict()
        for field in ['id', 'key', 'code', 'name', 'notes', 'keyvalues']:
            assert field in ans, ans
        for field in ['id', 'name', 'keyvalues']:
            assert field in ans['key'], ans
        for key in ['population2006']:
            assert key in ans['keyvalues'], ans

