import json
import os
import pkg_resources
import wdmmg.model as model
from wdmmgext.load import dfid

class TestDfid(object):
	
    @classmethod
    def setup_class(self):
        model.repo.delete_all()
        model.Session.remove()
        self.name = dfid.dataset_name
        filepath = 'wdmmg/tests/dfid_short.xls'
        test_file = os.path.abspath(filepath)
        dfid.load_file(filepath, commit_every=1)
        model.Session.commit()
        model.Session.remove()

    @classmethod
    def teardown_class(self):
        model.repo.delete_all()
        model.Session.commit()
        model.Session.remove()

	# check dataset exists
    def test_01_dataset(self):
        out = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).first()
        assert out, out

	# get all our keys, and check values exist for them
    def test_02_classification(self):
        for key_name in [u'from', u'time', u'dfid_continent_or_agency', \
               u'dfid_continent_or_agency_sub', u'dfid_country_or_subagency']:
            key = model.Session.query(model.Key).filter_by(name=key_name).first()
            assert key, key_name
            count = (model.Session.query(model.ClassificationItem)
                .join(model.EnumerationValue)
                .filter_by(key=key)
                ).count()
            assert count, (key_name, count)

    # check there are some entries and none of them are null
    def test_03_entry(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        count = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).count()
        assert count, 'There are no Entries'
        assert not (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .filter_by(amount=None)
            ).first(), 'Some Entries have NULL amounts'
    
    # look for a 'to' field on the first entry in the dataset
    def test_04_entry_to(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        txn = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).first()
        classif = txn.classification_as_dict()
        assert classif['to'] == u'society'