# Test of the Disqus API.
#
# WDMMG has a Disqus account: wdmmg.  You will need to use this, or
# another Disqus account, to get a disqus API key (which should be
# stored into disqus.api_key in the pylon config).
#
# The Disqus API: http://groups.google.com/group/disqus-dev/web/api-1-1
#
# Currently this has very little to do with WDMMG proper, it's just a
# test that we can drive the Disqus API.
#
# TODO: would be nice to have an example of an API that requires POST,
# for example
# http://groups.google.com/group/disqus-dev/web/api-1-1#get_user_name.
# But I, drj, couldn't get it to work (using curl).

from wdmmg.tests import *

try: import json
except ImportError: import simplejson as json

from pylons import config
disqus_api_key = config.get('disqus.api_key', '')

# URL prefix for DISQUS_API
DISQUS_API = "http://disqus.com/api/"

import re
# http://docs.python.org/release/2.5.4/lib/module-urllib.html
import urllib

class TestDisqusController(TestController):
    __test__ = False

    @classmethod
    def setup_class(self):
        Fixtures.setup()
    
    @classmethod
    def teardown_class(self):
        Fixtures.teardown()

    def test_nothing(self):
        pass

    # Equivalent of:
    # curl -L "http://disqus.com/api/get_forum_list?user_api_key=API_KEY_HERE&api_version=1.1"
    # Which is a basic test of using GET on the API.
    def test_forum_list(self):
        f = urllib.urlopen(DISQUS_API +
          "get_forum_list?user_api_key=%s&api_version=1.1" %
          disqus_api_key)
        result = f.read()
        dict = json.loads(result)
        assert dict['succeeded']
        return dict

    def test_forum_api_key(self):
        forum_list = self.test_forum_list()['message']
        aforum = forum_list[0]
        f = urllib.urlopen(DISQUS_API +
          "get_forum_api_key?user_api_key=%s&forum_id=%s&api_version=1.1" %
          (disqus_api_key, aforum['id']))
        dict = json.load(f)
        assert dict['succeeded'], dict

