import json
import os
import pkg_resources
import wdmmg.model as model
from wdmmgext.load import uganda

class TestDepartments(object):

    @classmethod
    def setup_class(self):
        model.repo.delete_all()
        model.Session.remove()
        self.name = uganda.dataset_name
        filepath = 'wdmmg/tests/uganda_sample.xls'
        test_file = os.path.abspath(filepath)
        uganda.load_files(filename=test_file, commit_every=10)
        model.Session.commit()
        model.Session.remove()

    @classmethod
    def teardown_class(self):
        model.repo.delete_all()
        model.Session.commit()
        model.Session.remove()

    # check dataset exists
    def test_01_dataset(self):
        out = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).first()
        assert out, out

    # Get our keys, and check values exist for them.
    def test_02_classification(self):
        for key_name in [u'from', u'time', u'uganda_id', u'gou_vote',
                u'vote_name', u'project_code', u'project_name', u'funded_by_donor',
                u'funded_by_govt', u'mtef_sector', u'mtef_reference', 
                u'swg', u'sector_objective', u'peap1_pillar', 
                u'peap2_objective', u'peap3_area']:
            key = model.Session.query(model.Key).filter_by(name=key_name).first()
            assert key, key_name
            count = (model.Session.query(model.ClassificationItem)
                .join(model.EnumerationValue)
                .filter_by(key=key)
                ).count()
            assert count, (key_name, count)

    # Check there are some entries and none of them are null
    def test_03_entry(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        count = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).count()
        assert count, 'There are no Entries'
        assert not (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            .filter_by(amount=None)
            ).first(), 'Some Entries have NULL amounts'
    
    # Look for a 'to' field on the first entry in the dataset.
    def test_04_entry_to(self):
        dataset_ = (model.Session.query(model.Dataset)
            .filter_by(name=self.name)
            ).one()
        txn = (model.Session.query(model.Entry)
            .filter_by(dataset_=dataset_)
            ).first()
        classif = txn.classification_as_dict()
        print classif['to']
        assert classif['to'] == 'uganda-society'
