# -*- coding: utf-8 -*-

# Copyright 2014 Oliver Andrich
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.

import os

from flup.server.fcgi import WSGIServer
from weave import make_app

def main():
    # determine path to the data dir and create incase it is missing
    weave_dir = os.path.expanduser('~/.weave/')
    if not os.path.exists(weave_dir):
        os.mkdir(weave_dir)

    # check if registration should be enabled or disabled
    if os.path.exists(os.path.join(weave_dir, 'disable_registration')):
        enable_registration = False
    else:
        enable_registration = True

    # create WSGI Server
    application  = make_app(weave_dir, None, enable_registration)
    WSGIServer(application).run()
