from base_node import BaseNode


CMD_SET_STATE_OF_ALL_CHANNELS = 0xA0
CMD_GET_STATE_OF_ALL_CHANNELS = 0xA1
CMD_SET_PWM_ENABLED           = 0xA2
CMD_GET_PWM_ENABLED           = 0xA3
CMD_SET_PWM_STATE             = 0xA4
CMD_GET_PWM_STATE             = 0xA5


class HVSwitchingBoard(BaseNode):
    def __init__(self, proxy, address):
        BaseNode.__init__(self, proxy, address)

    def set_state_of_all_channels(self, state):
        for i in range(5):
          self.serialize_uint8(state[i])
        self.send_command(CMD_SET_STATE_OF_ALL_CHANNELS)

    def state_of_all_channels(self):
        self.data = []
        self.send_command(CMD_GET_STATE_OF_ALL_CHANNELS)
        return self.data

    def set_pwm_enabled(self, state):
        self.serialize_uint8(state)
        self.send_command(CMD_SET_PWM_ENABLED)

    def pwm_enabled(self):
        self.data = []
        self.send_command(CMD_GET_PWM_ENABLED)
        return self.read_uint8()

    def set_pwm_state(self, channel, duty_cycle, phase_offet):
        self.serialize_uint8(channel)
        self.serialize_uint8(duty_cycle)
        self.serialize_uint8(phase_offet)
        self.send_command(CMD_SET_PWM_STATE)

    def pwm_state(self, channel):
        self.data = []
        self.serialize_uint8(channel)
        self.send_command(CMD_GET_PWM_STATE)
        duty_cycle = self.read_uint8()
        phase_offset = self.read_uint8()
        return duty_cycle, phase_offset
