/*
 *     (C) Copyright 2012 Universidad Politécnica de Madrid
 *
 *     This file is part of Wirecloud Platform.
 *
 *     Wirecloud Platform is free software: you can redistribute it and/or
 *     modify it under the terms of the GNU Affero General Public License as
 *     published by the Free Software Foundation, either version 3 of the
 *     License, or (at your option) any later version.
 *
 *     Wirecloud is distributed in the hope that it will be useful, but WITHOUT
 *     ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *     FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
 *     License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with Wirecloud Platform.  If not, see
 *     <http://www.gnu.org/licenses/>.
 *
 */

(function () {

    "use strict";

    var platform, id, idx, tmp, i, current;

    platform = window.parent;

    // Get id from the URL
    idx = document.URL.lastIndexOf('#');
    tmp = document.URL.substr(idx + 1);
    tmp = tmp.split("&");
    for (i = 0; i < tmp.length; i++) {
        current = tmp[i];
        current = current.split("=", 2);
        if (current[0] === "id") {
            id = parseInt(current[1], 10);
            break;
        }
    }

    // API declaration
    Object.defineProperty(window, 'MashupPlatform', {value: {}});

    // HTTP module
    Object.defineProperty(window.MashupPlatform, 'http', {value: {}});
    Object.defineProperty(window.MashupPlatform.http, 'buildProxyURL', {value: platform.Wirecloud.io.buildProxyURL});
    Object.defineProperty(window.MashupPlatform.http, 'makeRequest', {value: platform.Wirecloud.io.makeRequest});
    Object.preventExtensions(window.MashupPlatform.http);

    // Widget Module
    Object.defineProperty(window.MashupPlatform, 'widget', {value: {}});
    Object.defineProperty(window.MashupPlatform.widget, 'id', {value: id});
    Object.preventExtensions(window.MashupPlatform.widget);

    // Pref Module
    Object.defineProperty(window.MashupPlatform, 'pref', {value: {}});
    Object.defineProperty(window.MashupPlatform.pref, 'get', {
        value: function get(key) {
            var variable = platform.opManager.activeWorkspace.varManager.getVariableByName(id, key);
            return variable.get();
        }
    });
    Object.defineProperty(window.MashupPlatform.pref, 'registerCallback', {
        value: function registerCallback(callback) {
            platform.opManager.activeWorkspace.getIWidget(id).registerPrefCallback(callback);
        }
    });
    Object.defineProperty(window.MashupPlatform.pref, 'set', {
        value: function get(key, value) {
            var variable = platform.opManager.activeWorkspace.varManager.getVariableByName(id, key);
            variable.set(value, true);
        }
    });
    Object.preventExtensions(window.MashupPlatform.pref);

    // Wiring Module
    Object.defineProperty(window.MashupPlatform, 'wiring', {value: {}});
    Object.defineProperty(window.MashupPlatform.wiring, 'registerCallback', {
        value: function registerCallback(inputName, callback) {
            platform.opManager.activeWorkspace.wiring.registerCallback(id, inputName, callback);
        }
    });
    Object.defineProperty(window.MashupPlatform.wiring, 'pushEvent', {
        value: function pushEvent(outputName, data) {
            platform.opManager.activeWorkspace.wiring.pushEvent(id, outputName, data);
        }
    });
    Object.preventExtensions(window.MashupPlatform.wiring);

    // StyledElements
    window.StyledElements = {
        'Event': window.parent.StyledElements.Event,
        'ObjectWithEvents': window.parent.StyledElements.ObjectWithEvents,
        'StyledElement': window.parent.StyledElements.StyledElement,
        'StyledButton': window.parent.StyledElements.StyledButton,
        'StyledInputElement': window.parent.StyledElements.StyledInputElement,
        'StyledTextField': window.parent.StyledElements.StyledTextField,
        'StyledPasswordField': window.parent.StyledElements.StyledPasswordField,
        'StyledSelect': window.parent.StyledElements.StyledSelect,
        'StyledTextArea': window.parent.StyledElements.StyledTextArea,
        'StaticPaginatedSource': window.parent.StyledElements.StaticPaginatedSource,
        'ModelTable': window.parent.StyledElements.ModelTable,
        'HorizontalLayout': window.parent.StyledElements.HorizontalLayout,
        'BorderLayout': window.parent.StyledElements.BorderLayout,
        'Tab': window.parent.StyledElements.Tab,
        'StyledNotebook': window.parent.StyledElements.StyledNotebook
    };

})();
