# -*- coding: utf-8 -*-

# Copyright 2012 Universidad Politécnica de Madrid

# This file is part of Wirecloud.

# Wirecloud is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Wirecloud is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Wirecloud.  If not, see <http://www.gnu.org/licenses/>.


from django.conf.urls.defaults import include, patterns, url
from django.views.decorators.cache import cache_page
from django.views.i18n import javascript_catalog

from wirecloud.platform import views
from wirecloud.platform.context import views as context_views
from wirecloud.platform.iwidget import views as iwidget_views
from wirecloud.platform.localcatalogue import views as localcatalogue_views
from wirecloud.platform.markets import views as market_views
from wirecloud.platform.plugins import get_plugin_urls
from wirecloud.platform.wiring import views as wiring_views
from wirecloud.platform.preferences import views as preferences_views
from wirecloud.platform.widget import views as widget_views
from wirecloud.platform.workspace import views as workspace_views


urlpatterns = patterns('wirecloud.platform.views',

    url(r'^$', 'render_root_page', name='wirecloud.root'),

    url(r'^api/features/?$',
        views.FeatureCollection(permitted_methods=('GET',)),
        name='wirecloud.features'),

    # i18n
    url(r'^api/i18n/', include('django.conf.urls.i18n')),
    url(r'^api/i18n/js_catalogue/?$',
        cache_page(60 * 60 * 24)(javascript_catalog), {'packages': ()},
        name="wirecloud.javascript_translation_catalogue"),

    url(r'^api/workspace/(?P<workspace_id>\d+)/wiring$',
        wiring_views.WiringEntry(permitted_methods=('PUT',)),
        name='wirecloud.workspace_wiring'),

    # Context
    url(r'^api/context/?',
        context_views.PlatformContextCollection(permitted_methods=('GET',)),
        name='wirecloud.platform_context_collection'),

    # Widgets
    url(r'^api/resources/?',
        localcatalogue_views.ResourceCollection(permitted_methods=('GET', 'POST',)),
        name='wirecloud_showcase.resource_collection'),
    url(r'^api/resource/(?P<vendor>[^/]+)/(?P<name>[^/]+)/(?P<version>[^/]+)/?',
        localcatalogue_views.ResourceEntry(permitted_methods=('DELETE',)),
        name='wirecloud_showcase.resource_entry'),
    url(r'^api/widget/(?P<vendor>[^/]+)/(?P<name>[^/]+)/(?P<version>[^/]+)/xhtml/?$',
        widget_views.WidgetCodeEntry(permitted_methods=('GET',)),
        name='wirecloud.widget_code_entry'),

    # IWidgets
    url(r'^api/workspace/(?P<workspace_id>\d+)/tab/(?P<tab_id>\d+)/iwidgets/?$',
        iwidget_views.IWidgetCollection(permitted_methods=('GET', 'POST', 'PUT',)),
        name='wirecloud.iwidget_collection'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/tab/(?P<tab_id>\d+)/iwidget/(?P<iwidget_id>\d+)/?$',
        iwidget_views.IWidgetEntry(permitted_methods=('GET', 'POST', 'PUT', 'DELETE',)),
        name='wirecloud.iwidget_entry'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/tab/(?P<tab_id>\d+)/iwidget/(?P<iwidget_id>\d+)/version/?$',
        iwidget_views.IWidgetVersion(permitted_methods=('PUT',)),
        name='wirecloud.iwidget_version_entry'
    ),

    # Preferences
    url(r'^api/preferences/platform/?',
        preferences_views.PlatformPreferencesCollection(permitted_methods=('GET', 'PUT')),
        name='wirecloud.platform_preferences'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/preferences/?$',
        preferences_views.WorkspacePreferencesCollection(permitted_methods=('GET', 'PUT')),
        name='wirecloud.workspace_preferences'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/tab/(?P<tab_id>\d+)/preferences/?$',
        preferences_views.TabPreferencesCollection(permitted_methods=('GET', 'PUT')),
        name='wirecloud.tab_preferences'
    ),

    url(r'^api/operators',
        wiring_views.OperatorCollection(permitted_methods=('GET',)),
        name='wirecloud.operators'
    ),
    url(r'^api/operator/(?P<vendor>[^/]+)/(?P<name>[^/]+)/(?P<version>[^/]+)/html',
        wiring_views.OperatorEntry(permitted_methods=('GET',)),
        name='wirecloud.operator_code_entry'
    ),

    url(r'^api/markets/?$', market_views.MarketCollection(permitted_methods=('GET', 'POST'))),
    url(r'^api/market/(?P<market>[\w -]+)/?$',
        market_views.MarketEntry(permitted_methods=('PUT', 'DELETE')),
        name='wirecloud.market_entry'),
    url(r'^api/market/(?P<user>[^/]*)/(?P<market>[\w -]+)/?$',
        market_views.MarketEntry(permitted_methods=('PUT', 'DELETE')),
        name='wirecloud.market_entry'),
    url(r'^api/markets/publish/?$',
        market_views.PublishService(),
        name='wirecloud.publish_on_other_marketplace'
    ),

    # Workspace
    url(r'^api/workspaces/?$',
        workspace_views.WorkspaceCollection(permitted_methods=('GET', 'POST', )),
        name='wirecloud.workspace_collection'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/?$',
        workspace_views.WorkspaceEntry(permitted_methods=('GET', 'POST', 'PUT', 'DELETE',)),
        name='wirecloud.workspace_entry'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/tabs/?$',
        workspace_views.TabCollection(permitted_methods=('GET', 'POST', 'PUT',)),
        name='wirecloud.tab_collection'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/tab/(?P<tab_id>\w+)/?$',
        workspace_views.TabEntry(permitted_methods=('GET', 'PUT', 'DELETE',)),
        name='wirecloud.tab_entry'
    ),

    url(r'^api/workspace/(?P<workspace_id>\d+)/variables/?$',
        workspace_views.WorkspaceVariableCollection(permitted_methods=('PUT',)),
        name='wirecloud.variable_collection'
    ),

    url(r'^api/workspace/(?P<workspace_id>\d+)/share/groups/?$', workspace_views.WorkspaceSharerEntry(permitted_methods=('GET', ))),
    url(r'^api/workspace/(?P<workspace_id>\d+)/share/(?P<share_boolean>\w+)/?$',
        workspace_views.WorkspaceSharerEntry(permitted_methods=('PUT',)),
        name='wirecloud.workspace_share'
    ),

    url(r'^api/workspace/(?P<workspace_id>\d+)/clone/?$', workspace_views.WorkspaceClonerEntry(permitted_methods=('GET', ))),
    url(r'^api/workspace/(?P<workspace_id>\d+)/link/?$', workspace_views.WorkspaceLinkerEntry(permitted_methods=('GET', ))),
    url(r'^api/workspace/(?P<to_ws_id>\d+)/merge/?$',
        workspace_views.MashupMergeService(),
        name='wirecloud.workspace_merge'
    ),
    url(r'^api/workspace/(?P<to_ws_id>\d+)/merge/(?P<from_ws_id>\d+)/?$',
        workspace_views.MashupMergeService(),
        name='wirecloud.workspace_merge_local'
    ),

    url(r'^api/workspace/(?P<workspace_id>\d+)/publish/?$',
        workspace_views.WorkspacePublisherEntry(permitted_methods=('POST',)),
        name='wirecloud.workspace_publish'
    ),
    url(r'^api/workspace/(?P<workspace_id>\d+)/export/?$',
        workspace_views.WorkspaceExportService(),
        name='wirecloud.workspace_export'
    ),

    url(r'^api/workspaces/import/?$',
        workspace_views.MashupImportService(),
        name="wirecloud.workspace_import"
    ),
    url(r'^api/workspaces/published/(?P<workspace_id>\d+)/template.xml$', workspace_views.MashupTemplate(permitted_methods=('GET', )), name='wirecloud_showcase.mashup_template'),

    url(r'^(?P<creator_user>[^/]+)/(?P<workspace>[^/]+)/?$', 'render_workspace_view', name='wirecloud.workspace_view'),
) + get_plugin_urls()
