# -*- coding: utf-8 -*-

# Copyright 2013 Universidad Politécnica de Madrid

# This file is part of Wirecloud.

# Wirecloud is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Wirecloud is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Wirecloud.  If not, see <http://www.gnu.org/licenses/>.


from django.db import models
from django.utils.translation import gettext_lazy as _


class Constant(models.Model):

    concept = models.CharField(_('Concept'), max_length=255, unique=True, null=False, blank=False)
    value = models.CharField(_('Value'), max_length=256)

    class Meta:
        app_label = 'platform'
        db_table = 'wirecloud_constant'

    def __unicode__(self):
        return self.concept.concept
