import urllib
from xml.dom import minidom

__all__ = ["wishes"]


def _getWishes():
    URL = "http://goo.gl/67wYX"
    urllib.urlcleanup()
    xmldata = minidom.parseString(urllib.urlopen(URL).read())
    columns = dict()
    for node in xmldata.getElementsByTagName("entry"):
        cell = node.getElementsByTagName("title")[0].childNodes[0].data
        if len(cell) == 2 and "1" in cell:
            content = node.getElementsByTagName("content")[0].childNodes[0].data
            columns[cell[0]] = content
    wishes = dict()
    for v in columns.values():
        wishes[v] = list()
    for i, node in enumerate(xmldata.getElementsByTagName("entry")):
        if i < len(columns):
            continue
        cell = node.getElementsByTagName("title")[0].childNodes[0].data
        k = columns.get(cell[0])
        content = node.getElementsByTagName("content")[0].childNodes[0].data
        wishes[k].append(content)
    return wishes

_keys = {"title": "I wish...",
         "description": "Describe your wish:",
         "date": "Timestamp",
         "category": "Category:",
         "author": "Beta testers",
         "platform": "Platform:"}

_wishes = _getWishes()
wishes = list()
for i, __ in enumerate(_wishes.values()[0]):
    wishes.append(dict())
    for k, v in _keys.iteritems():
        wishes[-1][str(k)] = str(_wishes.get(v)[i])
