import os
import sys
from PyQt4 import uic, QtGui
from wishlib.qt import QMainWindow
from .. import wish_manager


class MainWindow(QMainWindow):
    wishes = wish_manager.wishes
    data = ["uiTitle_lineEdit",
            "uiDescription_textEdit",
            "uiCategory_lineEdit",
            "uiPlatform_lineEdit",
            "uiAuthor_lineEdit"]

    def __init__(self, parent):
        super(MainWindow, self).__init__(parent)
        uifile = os.path.dirname(__file__)
        uifile = os.path.join(os.path.dirname(__file__), "ui", "mainwindow.ui")
        uifile = os.path.normpath(uifile)
        self.ui = uic.loadUi(uifile, self)
        self.setWindowTitle("{} - v0.1.2".format(self.windowTitle()))
        self.reload()

    def reload(self):
        self.uiFilter_comboBox.clear()
        self.uiWishes_listWidget.clear()
        categories = list()
        for i in self.wishes:
            self.uiWishes_listWidget.addItem(i.get("title"))
            categories.append(i.get("category"))
        categories = list(set(categories))
        self.uiFilter_comboBox.addItem("All")
        for category in categories:
            self.uiFilter_comboBox.addItem(category)

    def wish_OnChanged(self, name):
        i = self.uiWishes_listWidget.currentRow()
        wish = self.wishes[i]
        for attr in self.data:
            for k in wish.keys():
                if k not in attr.lower():
                    continue
                widget = getattr(self, attr)
                widget.setText(wish.get(k))

    def filter_OnChanged(self, category):
        for i in self.data:
            widget = getattr(self, i)
            widget.setText("")
        for i in range(self.uiWishes_listWidget.count()):
            item = self.uiWishes_listWidget.item(i)
            wish = self.wishes[i]
            hidden = wish.get("category") != str(category)
            if category == "All":
                hidden = False
            item.setHidden(hidden)


def main():
    app = QtGui.QApplication(sys.argv)
    win = MainWindow(None)
    win.show()
    sys.exit(app.exec_())
