#!/usr/bin/env python

from setuptools import setup
from decimal import Decimal
import re

def verno(s):
    """
    Update the version number passed in by extending it to the 
    thousands place and adding 1/1000, then returning that result
    and as a side-effect updating setup.py

    Dangerous, self-modifying, and also, helps keep version numbers
    ascending without human intervention.
    """
    d = Decimal(s)
    increment = Decimal('0.001')
    d = d.quantize(increment) + increment
    dstr = str(d)
    setup = open('setup.py', 'r').read()
    setup = re.sub('verno\(\w*[\'"]([\d\.]+)[\'"]', 'verno("' + dstr + '"', setup)
    open('setup.py', 'w').write(setup)
    return dstr

setup(
    name='withref',
    version=verno("0.103"),
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description="Use Python's with statement to simplify multi-level object dereferences, reminisent of Pascal's with statement",
    long_description=open("README.rst").read(),
    url='https://bitbucket.org/jeunice/withref',
    py_modules=['withref'],
    install_requires=['stuf'],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: BSD License',
        'Intended Audience :: Developers',
        'Programming Language :: Python',
    ]
)
