import sys
import os.path

from wizard import command, deploy, shell

def main(argv, baton):
    options, args = parse_args(argv, baton)
    wc = deploy.WorkingCopy(".")
    wc.verify()
    wc.verifyConfigured()
    # worst case scenario protection
    for file in wc.application.parametrized_files:
        shell.call("git", "add", file)
    shell.call("git", "commit", "--allow-empty", "-am", "Protection commit")
    shell.call("git", "reset", "HEAD~")
    wc.prepareConfig()

def parse_args(argv, baton):
    usage = """usage: %prog prepare-config

During the preparation of an upgrade, changes to configuration files
must be taken into account.  Unfortunately, configuration files
are not commonly versioned, and are commonly autogenerated.  Running
this command will update all configuration files.

To be more specific, it replaces the specific values from the installation
back with generic values, which can be committed to the repository.  The final
working copy state has HEAD pointing to the -scripts version that the commit
was based off of, but with local changes that can be incorporated using
`git commit --amend -a`.  You should inspect the changes with `git diff`;
it is possible that the regular expressions in wizard.app.APPNAME are
now non-functional.

Wizard should be run in the environment installations are planned
to be deployed to, because installers can have subtle differences
in configuration files based on detected server configuration.
"""
    parser = command.WizardOptionParser(usage)
    return parser.parse_all(argv)

