# -*- coding: utf-8 -*-
from PySide.QtGui import *
from PySide.QtCore import *
import sys

QTextCodec.setCodecForTr(QTextCodec.codecForName("utf8"))

class MainWindow(QMainWindow):
    def __init__(self,parent=None):
        super(MainWindow,self).__init__(parent)
        self.setWindowTitle(self.tr("打印机"))
        self.text=QTextEdit()
        self.setCentralWidget(self.text)
        
        self.createActions()
        self.createMenus()
        self.createToolBars()

        file=QFile("QPrinter.txt")
        if file.open(QIODevice.ReadOnly|QIODevice.Text):
            textStream=QTextStream(file)
            while not textStream.atEnd():
                self.text.append(textStream.readLine())
        file.close()

    def createActions(self):
        self.PrintAction=QAction(QIcon("images/print.png"),self.tr("打印"),self)
        self.PrintAction.setShortcut("Ctrl+P")
        self.PrintAction.setStatusTip(self.tr("打印"))
        self.connect(self.PrintAction,SIGNAL("triggered()"),self.slotPrint)

    def createMenus(self):
        PrintMenu=self.menuBar().addMenu(self.tr("打印"))
        PrintMenu.addAction(self.PrintAction)

    def createToolBars(self):
        fileToolBar=self.addToolBar("Print")
        fileToolBar.addAction(self.PrintAction)

    def slotPrint(self):
        printer=QPrinter()
        printDialog=QPrintDialog(printer,self)
        if printDialog.exec_():
            doc=self.text.document()
            doc.print_(printer)
        
app=QApplication(sys.argv)
main=MainWindow()
main.show()
app.exec_()
