#!/usr/bin/env python
from comtypes import COMError
from wmdlib.lowlevel.errorcodes import *

def com_optional_func(fun):
    """Decorator for test function that test an optional COM function.
    (That might return E_NOTIMPL)"""
    def newfun(*args, **kwargs):
        try:
            return fun(*args, **kwargs)
        except COMError, ce:
            if not (ce.hresult + 0x100000000) == E_NOTIMPL:
                raise ce
    newfun.__name__ = fun.__name__
    return newfun