#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *


class WordsApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def searchWords(self, query, **kwargs):
        """Searches words

        Args:
            query, str: Search query (required)
            includePartOfSpeech, str: Only include these comma-delimited parts of speech (optional)
            excludePartOfSpeech, str: Exclude these comma-delimited parts of speech (optional)
            caseSensitive, str: Search case sensitive (optional)
            minCorpusCount, int: Minimum corpus frequency for terms (optional)
            maxCorpusCount, int: Maximum corpus frequency for terms (optional)
            minDictionaryCount, int: Minimum number of dictionary entries for words returned (optional)
            maxDictionaryCount, int: Maximum dictionary definition count (optional)
            minLength, int: Minimum word length (optional)
            maxLength, int: Maximum word length (optional)
            skip, int: Results to skip (optional)
            limit, int: Maximum number of results to return (optional)
            
        Returns: WordSearchResults
        """

        allParams = ['query', 'includePartOfSpeech', 'excludePartOfSpeech', 'caseSensitive', 'minCorpusCount', 'maxCorpusCount', 'minDictionaryCount', 'maxDictionaryCount', 'minLength', 'maxLength', 'skip', 'limit']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method searchWords" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/words.{format}/search/{query}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('caseSensitive' in params):
            queryParams['caseSensitive'] = self.apiClient.toPathValue(params['caseSensitive'])
        if ('includePartOfSpeech' in params):
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(params['includePartOfSpeech'])
        if ('excludePartOfSpeech' in params):
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(params['excludePartOfSpeech'])
        if ('minCorpusCount' in params):
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(params['minCorpusCount'])
        if ('maxCorpusCount' in params):
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(params['maxCorpusCount'])
        if ('minDictionaryCount' in params):
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(params['minDictionaryCount'])
        if ('maxDictionaryCount' in params):
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(params['maxDictionaryCount'])
        if ('minLength' in params):
            queryParams['minLength'] = self.apiClient.toPathValue(params['minLength'])
        if ('maxLength' in params):
            queryParams['maxLength'] = self.apiClient.toPathValue(params['maxLength'])
        if ('skip' in params):
            queryParams['skip'] = self.apiClient.toPathValue(params['skip'])
        if ('limit' in params):
            queryParams['limit'] = self.apiClient.toPathValue(params['limit'])
        if ('query' in params):
            replacement = str(self.apiClient.toPathValue(params['query']))
            resourcePath = resourcePath.replace('{' + 'query' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'WordSearchResults')
        return responseObject
        
        
    def getWordOfTheDay(self, **kwargs):
        """Returns a specific WordOfTheDay

        Args:
            date, str: Fetches by date in yyyy-MM-dd (optional)
            
        Returns: WordOfTheDay
        """

        allParams = ['date']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getWordOfTheDay" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/words.{format}/wordOfTheDay'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('date' in params):
            queryParams['date'] = self.apiClient.toPathValue(params['date'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'WordOfTheDay')
        return responseObject
        
        
    def reverseDictionary(self, query, **kwargs):
        """Reverse dictionary search

        Args:
            query, str: Search term (required)
            findSenseForWord, str: Restricts words and finds closest sense (optional)
            includeSourceDictionaries, str: Only include these comma-delimited source dictionaries (optional)
            excludeSourceDictionaries, str: Exclude these comma-delimited source dictionaries (optional)
            includePartOfSpeech, str: Only include these comma-delimited parts of speech (optional)
            excludePartOfSpeech, str: Exclude these comma-delimited parts of speech (optional)
            expandTerms, str: Expand terms (optional)
            sortBy, str: Attribute to sort by (optional)
            sortOrder, str: Sort direction (optional)
            minCorpusCount, int: Minimum corpus frequency for terms (optional)
            maxCorpusCount, int: Maximum corpus frequency for terms (optional)
            minLength, int: Minimum word length (optional)
            maxLength, int: Maximum word length (optional)
            includeTags, str: Return a closed set of XML tags in response (optional)
            skip, str: Results to skip (optional)
            limit, int: Maximum number of results to return (optional)
            
        Returns: DefinitionSearchResults
        """

        allParams = ['query', 'findSenseForWord', 'includeSourceDictionaries', 'excludeSourceDictionaries', 'includePartOfSpeech', 'excludePartOfSpeech', 'expandTerms', 'sortBy', 'sortOrder', 'minCorpusCount', 'maxCorpusCount', 'minLength', 'maxLength', 'includeTags', 'skip', 'limit']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method reverseDictionary" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/words.{format}/reverseDictionary'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('query' in params):
            queryParams['query'] = self.apiClient.toPathValue(params['query'])
        if ('findSenseForWord' in params):
            queryParams['findSenseForWord'] = self.apiClient.toPathValue(params['findSenseForWord'])
        if ('includeSourceDictionaries' in params):
            queryParams['includeSourceDictionaries'] = self.apiClient.toPathValue(params['includeSourceDictionaries'])
        if ('excludeSourceDictionaries' in params):
            queryParams['excludeSourceDictionaries'] = self.apiClient.toPathValue(params['excludeSourceDictionaries'])
        if ('includePartOfSpeech' in params):
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(params['includePartOfSpeech'])
        if ('excludePartOfSpeech' in params):
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(params['excludePartOfSpeech'])
        if ('minCorpusCount' in params):
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(params['minCorpusCount'])
        if ('maxCorpusCount' in params):
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(params['maxCorpusCount'])
        if ('minLength' in params):
            queryParams['minLength'] = self.apiClient.toPathValue(params['minLength'])
        if ('maxLength' in params):
            queryParams['maxLength'] = self.apiClient.toPathValue(params['maxLength'])
        if ('expandTerms' in params):
            queryParams['expandTerms'] = self.apiClient.toPathValue(params['expandTerms'])
        if ('includeTags' in params):
            queryParams['includeTags'] = self.apiClient.toPathValue(params['includeTags'])
        if ('sortBy' in params):
            queryParams['sortBy'] = self.apiClient.toPathValue(params['sortBy'])
        if ('sortOrder' in params):
            queryParams['sortOrder'] = self.apiClient.toPathValue(params['sortOrder'])
        if ('skip' in params):
            queryParams['skip'] = self.apiClient.toPathValue(params['skip'])
        if ('limit' in params):
            queryParams['limit'] = self.apiClient.toPathValue(params['limit'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DefinitionSearchResults')
        return responseObject
        
        
    def getRandomWords(self, **kwargs):
        """Returns an array of random WordObjects

        Args:
            includePartOfSpeech, str: CSV part-of-speech values to include (optional)
            excludePartOfSpeech, str: CSV part-of-speech values to exclude (optional)
            sortBy, str: Attribute to sort by (optional)
            sortOrder, str: Sort direction (optional)
            hasDictionaryDef, str: Only return words with dictionary definitions (optional)
            minCorpusCount, int: Minimum corpus frequency for terms (optional)
            maxCorpusCount, int: Maximum corpus frequency for terms (optional)
            minDictionaryCount, int: Minimum dictionary count (optional)
            maxDictionaryCount, int: Maximum dictionary count (optional)
            minLength, int: Minimum word length (optional)
            maxLength, int: Maximum word length (optional)
            limit, int: Maximum number of results to return (optional)
            
        Returns: list[WordObject]
        """

        allParams = ['includePartOfSpeech', 'excludePartOfSpeech', 'sortBy', 'sortOrder', 'hasDictionaryDef', 'minCorpusCount', 'maxCorpusCount', 'minDictionaryCount', 'maxDictionaryCount', 'minLength', 'maxLength', 'limit']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getRandomWords" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/words.{format}/randomWords'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('hasDictionaryDef' in params):
            queryParams['hasDictionaryDef'] = self.apiClient.toPathValue(params['hasDictionaryDef'])
        if ('includePartOfSpeech' in params):
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(params['includePartOfSpeech'])
        if ('excludePartOfSpeech' in params):
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(params['excludePartOfSpeech'])
        if ('minCorpusCount' in params):
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(params['minCorpusCount'])
        if ('maxCorpusCount' in params):
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(params['maxCorpusCount'])
        if ('minDictionaryCount' in params):
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(params['minDictionaryCount'])
        if ('maxDictionaryCount' in params):
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(params['maxDictionaryCount'])
        if ('minLength' in params):
            queryParams['minLength'] = self.apiClient.toPathValue(params['minLength'])
        if ('maxLength' in params):
            queryParams['maxLength'] = self.apiClient.toPathValue(params['maxLength'])
        if ('sortBy' in params):
            queryParams['sortBy'] = self.apiClient.toPathValue(params['sortBy'])
        if ('sortOrder' in params):
            queryParams['sortOrder'] = self.apiClient.toPathValue(params['sortOrder'])
        if ('limit' in params):
            queryParams['limit'] = self.apiClient.toPathValue(params['limit'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[WordObject]')
        return responseObject
        
        
    def getRandomWord(self, **kwargs):
        """Returns a single random WordObject

        Args:
            includePartOfSpeech, str: CSV part-of-speech values to include (optional)
            excludePartOfSpeech, str: CSV part-of-speech values to exclude (optional)
            hasDictionaryDef, str: Only return words with dictionary definitions (optional)
            minCorpusCount, int: Minimum corpus frequency for terms (optional)
            maxCorpusCount, int: Maximum corpus frequency for terms (optional)
            minDictionaryCount, int: Minimum dictionary count (optional)
            maxDictionaryCount, int: Maximum dictionary count (optional)
            minLength, int: Minimum word length (optional)
            maxLength, int: Maximum word length (optional)
            
        Returns: WordObject
        """

        allParams = ['includePartOfSpeech', 'excludePartOfSpeech', 'hasDictionaryDef', 'minCorpusCount', 'maxCorpusCount', 'minDictionaryCount', 'maxDictionaryCount', 'minLength', 'maxLength']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getRandomWord" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/words.{format}/randomWord'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('hasDictionaryDef' in params):
            queryParams['hasDictionaryDef'] = self.apiClient.toPathValue(params['hasDictionaryDef'])
        if ('includePartOfSpeech' in params):
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(params['includePartOfSpeech'])
        if ('excludePartOfSpeech' in params):
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(params['excludePartOfSpeech'])
        if ('minCorpusCount' in params):
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(params['minCorpusCount'])
        if ('maxCorpusCount' in params):
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(params['maxCorpusCount'])
        if ('minDictionaryCount' in params):
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(params['minDictionaryCount'])
        if ('maxDictionaryCount' in params):
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(params['maxDictionaryCount'])
        if ('minLength' in params):
            queryParams['minLength'] = self.apiClient.toPathValue(params['minLength'])
        if ('maxLength' in params):
            queryParams['maxLength'] = self.apiClient.toPathValue(params['maxLength'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'WordObject')
        return responseObject
        
        
    


