#!/usr/bin/env python
"""
WordListAPI.py
Copyright 2011 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../')
import model

class WordListAPI(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    def updateWordList(self, wordListId, auth_token, postData=None, ):
        """Updates an existing WordList
        Args:
            wordListId -- ID of WordList to update
            postData -- Updated WordList
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}


        if wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListId)

        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)
    def deleteWordList(self, wordListId, auth_token, ):
        """Deletes an existing WordList
        Args:
            wordListId -- ID of WordList to delete
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}


        if wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListId)

        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
    def getWordListById(self, wordListId, auth_token, ):
        """Fetches a WordList by ID
        Args:
            wordListId -- ID of WordList to fetch
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

        Return:
            WordList -- an instance of WordList"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}


        if wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListId)

        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.WordList.WordList)
        return responseObject


    def addWordsToWordList(self, wordListId, auth_token, postData=None, ):
        """Adds words to a WordList
        Args:
            wordListId -- ID of WordList to user
            postData -- Array of words to add to WordList
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}/words'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}


        if wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListId)

        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)
    def getWordListWords(self, wordListWordsInput=None, ):
        """Fetches words in a WordList
        Args:
            wordListWordsInput -- 

        Return:
            list<WordListWord> -- an instance of WordListWord"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}/words'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordListWordsInput != None and wordListWordsInput.sortBy != None:
            queryParams['sortBy'] = self.apiClient.toPathValue(wordListWordsInput.sortBy)

        if wordListWordsInput != None and wordListWordsInput.sortOrder != None:
            queryParams['sortOrder'] = self.apiClient.toPathValue(wordListWordsInput.sortOrder)

        if wordListWordsInput != None and wordListWordsInput.skip != None:
            queryParams['skip'] = self.apiClient.toPathValue(wordListWordsInput.skip)

        if wordListWordsInput != None and wordListWordsInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordListWordsInput.limit)


        if wordListWordsInput != None and wordListWordsInput.wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListWordsInput.wordListId)

        if wordListWordsInput != None and wordListWordsInput.auth_token != None:
			headerParams['auth_token'] = self.apiClient.toPathValue(wordListWordsInput.auth_token)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.WordListWord.WordListWord))
        return responseObjects
    def deleteWordsFromWordList(self, wordListId, auth_token, postData=None, ):
        """Removes words from a WordList
        Args:
            wordListId -- ID of WordList to use
            postData -- Words to remove from WordList
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

"""

        # Parse inputs
        resourcePath = '/wordList.{format}/{wordListId}/deleteWords'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}


        if wordListId != None:
            resourcePath = resourcePath.replace('{wordListId}', wordListId)

        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)
